/* tc-04 - remake */

/* This program draws a solid 3d sphere using the plain equation
	method of hidden surface removal.*/

/* ----------------------------------------------------------------------- */
/* INCLUDE FILES */
#include <process.h>
#include <bios.h>
#include <stdio.h>
#include <graphics.h>
#include <math.h>

/* ----------------------------------------------------------------------- */
/* DECLARATIONS */
/* global variables */

float		x=0.0,y=0.0,z=0.0;
float		x1=0.0,x2=0.0,x3=0.0,x4=0.0;
float		y01=0.0,y2=0.0,y3=0.0,y4=0.0;
float		z1=0.0,z2=0.0,z3=0.0,z4=0.0;
float		sx1=0.0,sx2=0.0,sx3=0.0,sx4=0.0,sx5=0.0;
float		sy1=0.0,sy2=0.0,sy3=0.0,sy4=0.0,sy5=0.0;
float		sx=0.0,sy=0.0;
float		xa=0.0,ya=0.0,za=0.0;
float		d=1200.0;
double	r1=6.19592;
double	r2=.523590;
double	r3=5.39778;
double	sr1=0.0,sr2=0.0,sr3=0.0;
double	cr1=0.0,cr2=0.0,cr3=0.0;
float		mx=0.0,my=0.0,mz=-160;
int		maxx=839,minx=0,maxy=199,miny=0;
float		screen_x=639,screen_y=199;
float		rx=0.0,ry=0.0;
int		t=0,t1=0,t2=0;
int		p1=0;
int		C0=0,C1=1,C2=2,C3=3,C4=4,C5=5,C6=6,C7=7,C8=8,C9=9,
			C10=10,C11=11,C12=12,C13=13,C14=14,C15=15,
			mode_flag=0;
int		key_matte_clr=6;
int		edge_clr=7;
int		solid_clr=0;
float		x_res,y_res;
float		sp=0.0;
float		sp1=0.0,sp2=0.0,sp3=0.0;
float		xlarge=0.0,xsmall=0.0;
float    ylarge=0.0,ysmall=0.0;
float		zlarge=0.0,zsmall=0.0;
float		x6=0.0,x7=0.0,y6=0.0,y7=0.0,z6=0.0,z7=0.0;

int		q=0,q1=0,q2=0;
double	r4=6.28319,r5=6.28319;
float		B11[36][3];
float		B12[36][3];
float		B21[36][2];
float		B22[36][2];
int		polary[4][2];  /* used in my 3d solid polygon draw routine */
double	sr4=0.0,cr4=0.0,sr5=0.0,cr5=0.0;

/* declare global subroutines */
void keyboard(void);void quit_pgm(void);void calc_3d(void);
void rotation(void);void window(void);void graphics_setup(void);
void coords(void);void draw_poly(void);void notice(int x,int y);
void visibility_test(void);void polycenter(void);

void sphere_coords(void);void draw_4poly(void);
void draw_3polynorth(void);void draw_3polysouth(void);
void upper_coords(void);void lower_coords(void);

/* ----------------------------------------------------------------------- */
/* MAIN ROUTINE */
main(){
graphics_setup();
setviewport(0,0,maxx,maxy,1);
key_matte_clr=C6;
edge_clr=C7;solid_clr=C0;
rotation();

/* DRAW NORTH POLAR REGION */
r5=0.0;r4=0.0;x=30;sphere_coords();calc_3d();window();
B11[0][0]=x;B11[0][1]=y;B11[0][2]=z;
B21[0][0]=sx;B21[0][1]=sy;
x=30;r5=.17453;r4=0.0;lower_coords();
for (q1=0;q1<=35;q1++){
	q2=q1+1;if (q2>35) q2=0;
	draw_3polynorth();
	keyboard();
}

/* DRAW POLYGONS ALONG BELTS OF SPHERES */
r5=.17453;
for (t2=1;t2<=16;t2++){
	x=30;r4=0.0;upper_coords();
	x=30;r5=r5+.17453;r4=0.0;lower_coords();
	for (q1=0;q1<=35;q1++){
		q2=q1+1;if (q2>35) q2=0;
		draw_4poly();
		keyboard();
		}
	}

/* DRAW SOUTH POLAR REGIONS */
r5=3.14159;r4=0.0;x=30;sphere_coords();calc_3d();window();
B21[0][0]=x;B21[0][1]=y;B21[0][2]=z;
B22[0][0]=sx;B22[0][1]=sy;
x=30;r5=2.96706;r4=0.0;upper_coords();
for (q1=0;q1<=35;q1++){
	q2=q1+1;if (q2>35) q2=0;
	draw_3polysouth();
	keyboard();
}

setcolor(C7);notice(0,0);
for (t1=1;t1!=2;) keyboard();
quit_pgm();
}

/* ----------------------------------------------------------------------- */
/* SUBROUTINE: CALCULATE AND STORE COORDS FOR BELT */

void upper_coords(void){
for (t=0;t<=35;t++){
	x=30;sphere_coords();calc_3d();window();
	B11[t][0]=x;B11[t][1]=y;B11[t][2]=z;
	B21[t][0]=sx;B21[t][1]=sy;
	r4=r4+.17453;
	keyboard();}
	return;}

void lower_coords(void){
	for (t=0;t<=35;t++){
	x=30;sphere_coords();calc_3d();window();
	B12[t][0]=x;B12[t][1]=y;B12[t][2]=z;
	B22[t][0]=sx;B22[t][1]=sy;
	r4=r4+.17453;
	keyboard();}
return;}

/* ----------------------------------------------------------------------- */
/* SUBROUTINE: CALCULATE WORLD COORDINATES FOR SPHERE */

void sphere_coords(void){
sr4=sin(r4);cr4=cos(r4);sr5=sin(r5);
cr5=cos(r5);x1=sr5*x;y=cr5*x;x=cr4*x1;z=sr4*x1;return;}

/* ----------------------------------------------------------------------- */
/* SUBROUTINE: DRAW 4 SIDED POLYGON SURFACE ON SPHERE */

void draw_4poly(void){
x1=B11[q1][0];y01=B11[q1][1];z1=B11[q1][2];
x2=B11[q2][0];y2=B11[q2][1];z2=B11[q2][2];
x3=B12[q2][0];y3=B12[q2][1];z3=B12[q2][2];
x4=B12[q1][0];y4=B12[q1][1];z4=B12[q1][2];
sx1=B21[q1][0];sy1=B21[q1][1];
sx2=B21[q2][0];sy2=B21[q2][1];
sx3=B22[q2][0];sy3=B22[q2][1];
sx4=B22[q1][0];sy4=B22[q1][1];
polycenter();
draw_poly();
return;}

/* ----------------------------------------------------------------------- */
/* SUBROUTINE: DRAW 3 SIDED POLYGONAL SURFACE ON SPHERE */

void draw_3polynorth(void){
x1=B12[q2][0];y01=B12[q2][1];z1=B12[q2][2];
x2=B12[q1][0];y2=B12[q1][1];z2=B12[q1][2];
x3=B11[0][0];y3=B11[0][1];z3=B11[0][2];
sx1=B22[q2][0];sy1=B22[q2][1];
sx2=B22[q1][0];sy2=B22[q1][1];
sx3=B21[0][0];sy3=B21[0][1];
sx4=sx1;sy4=sy1;
x4=x1+.5*(x2-x1);y4=y01+.5*(y2-y01);z4=z1+.5*(z2-z1);
x=x3+.85*(x4-x3);y=y3+.85*(y4-y3);z=z3+.85*(z4-z3);
sx=d*x/z;sy=d*y/z;window();sx5=sx;sy5=sy;
draw_poly();
return;}

void draw_3polysouth(void){
x1=B12[q1][0];y01=B12[q1][1];z1=B12[q1][2];
x2=B12[q2][0];y2=B12[q2][1];z2=B12[q2][2];
x3=B11[0][0];y3=B11[0][1];z3=B11[0][2];
sx1=B21[q2][0];sy1=B21[q2][1];
sx2=B22[q1][0];sy2=B22[q1][1];
sx3=B22[0][0];sy3=B22[0][1];
sx4=sx1;sy4=sy1;
x4=x1+.5*(x2-x1);y4=y01+.5*(y2-y01);z4=z1+.5*(z2-z1);
x=x3+.85*(x4-x3);y=y3+.85*(y4-y3);z=z3+.85*(z4-z3);
sx=d*x/z;sy=d*y/z;window();sx5=sx;sy5=sy;
draw_poly();
return;}

/* ----------------------------------------------------------------------- */
/* SUBROUTINE: IDENTIFY CENTER OF POLYGON */

void polycenter(void){x6=x2+.5*(x1-x2);y6=y2+.5*(y01-y2);
z6=z2+.5*(z1-z2);x7=x3+.5*(x4-x3);y7=y3+.5*(y4-y3);z7=z3+.5*(z4-z3);
x=x7+.5*(x6-x7);y=y7+.5*(y6-y7);z=z7+.5*(z6-z7);sx=d*x/z;sy=d*y/z;
window();sx5=sx;sy5=sy;return;}

/* ----------------------------------------------------------------------- */
/* SUBROUTINE: CALCULATE SIN,COS FACTORS */

void rotation(void){
sr1=sin(r1);sr2=sin(r2);sr3=sin(r3);cr1=cos(r1);cr2=cos(r2);
cr3=cos(r3);return;}

/* ----------------------------------------------------------------------- */
/* SUBROUTINE: STANDARD 3D FORMULAS */
/* Pass: x,y,z cartesian world coordinates.
   Returns: sx,sy cartesian display coordinates.
		  x,y,z catesian view coordinates */

void calc_3d(void){
x=(-1)*x;xa=cr1*x-sr1*z;za=sr1*x+cr1*z;x=cr2*xa+sr2*y;
ya=cr2*y-sr2*xa;z=cr3*za-sr3*ya;y=sr3*za+cr3*ya;x=x+mx;y=y+my;
z=z+mz;sx=d*x/z;sy=d*y/z;return;}

/* ----------------------------------------------------------------------- */
/* HIDDEN SURFACE VISIBILTY TEST */
void visibility_test(void){
sp1=x1*(y2*z3-y3*z2);sp1=(-1)*sp1;sp2=x2*(y3*z1-y01*z3);
sp3=x3*(y01*z2-y2*z1);sp=sp1-sp2-sp3;return;}

/* ----------------------------------------------------------------------- */
/* SUBROUTINE: DRAW 4-SIDED SOLID POLYGON IN 3D SPACE */

void draw_poly(void){
setlinestyle(USERBIT_LINE,0xffff,NORM_WIDTH);
setfillstyle(SOLID_FILL,solid_clr);
setcolor(edge_clr);

polary[0][0]=sx1;polary[0][1]=sy1;polary[1][0]=sx2;polary[1][1]=sy2;
polary[2][0]=sx3;polary[2][1]=sy3;polary[3][0]=sx4;polary[3][1]=sy4;

drawpoly (4,(int far*) polary);
return;
}

/* ----------------------------------------------------------------------- */
/* SUBROUTINE: MAP CARTESIAN COORDS TO PHYSICAL SCREEN COORDS */

void window(void){
sx=sx+399;sy=sy+299;rx=screen_x/799;ry=screen_y/599;sx=sx*rx;
sy=sy*ry;return;}

/* ----------------------------------------------------------------------- */
/* SUBROUTINE: CHACK THE KEYBOARD BUFFER */
void keyboard(void){
if (bioskey(1)==0) return; else quit_pgm();}

/* ----------------------------------------------------------------------- */
/* SUBROUTINE: GRACEFUL EXIT FROM PROGRAM */

void quit_pgm(void){
cleardevice();restorecrtmode();exit(0);}

/* ----------------------------------------------------------------------- */
/* SUBROUTINE: VGA/EGA/MCGA/CGA COMPATIBILITY MODULE */

void graphics_setup(void){
int graphics_adapter,graphics_mode;
detectgraph(&graphics_adapter,&graphics_mode);
if (graphics_adapter==VGA) goto VGA_mode;
if (graphics_mode==EGAHI) goto EGA_ECD_mode;
if (graphics_mode==EGALO) goto EGA_SCD_mode;
if (graphics_adapter==CGA) goto abort_message;
if (graphics_adapter==MCGA) goto abort_message;
goto abort_message;

VGA_mode:
graphics_adapter=VGA;graphics_mode=VGAHI;
initgraph(&graphics_adapter,&graphics_mode,"");
x_res=640;y_res=480;mode_flag=1;
	maxx=639;minx=0;maxy=479;miny=0;screen_x=639;screen_y=479;
	setcolor(7);moveto(0,472);
	outtext("Revisions by A. Helder");
	moveto(472,472);
	outtext("Press any key to quit");
	moveto(160,0);
	outtext("USING C TO GENERATE A HOLLOW 3D SPHERE");
	return;

EGA_ECD_mode:
graphics_adapter=EGA;graphics_mode=EGAHI;
initgraph(&graphics_adapter,&graphics_mode,"");
x_res=640;y_res=350;mode_flag=2;
	maxx=639;minx=0;maxy=349;miny=0;screen_x=639;screen_y=349;
	setcolor(7);moveto(0,342);
	outtext("Revisions by A. Helder");
	moveto(472,342);
	outtext ("Press any key to quit");
	moveto(160,0);
	outtext("USING C TO GENERATE A HOLLOW 3D SPHERE");
	return;

EGA_SCD_mode:
graphics_adapter=EGA;graphics_mode=EGALO;
initgraph(&graphics_adapter,&graphics_mode,"");
x_res=640;y_res=200;mode_flag=3;
	maxx=639;minx=0;maxy=199;miny=0;screen_x=639;screen_y=199;
	setcolor(7);moveto(0,192);
	outtext("Revisions by A. Helder");
	moveto(472,192);
	outtext("PRESS ANY KEY TO QUIT");
	moveto(160,0);
	outtext("USING C TO GENERATE A HOLLOW 3D SPHERE");
	return;


abort_message:
printf("\n\nUnable to proceed - Requires VGA or EGA adapter");
printf("\nWith appropriate monitor");
exit(0);
}

/* ----------------------------------------------------------------------- */
/* SUBROUTINE: MAP 640*480 TEMPLATE TO 2D SCREEN */
void coords(void)
{
sx=sx*(x_res/640);sy=sy*(y_res/480);return;
}

/* ----------------------------------------------------------------------- */
/* SUBROUTINE: COPYRIGHT NOTICE */

int copyright[][3]={0x7c00,0x0000,0x0000,0x8231,
0x819c,0x645e,0xba4a,0x4252,0x96d0,0xa231,0x8252,0x955e,0xba4a,
0x43d2,0xf442,0x8231,0x825c,0x945e,0x7c00,0x0000,0x0000};

void notice(int x, int y){
int a,b,c; int t1=0;

for (t1=0;t1<=6;t1++)
	{
	a=copyright[t1][0];b=copyright[t1][1];
	c=copyright[t1][2];
	setlinestyle(USERBIT_LINE,a,NORM_WIDTH);
	moveto(x,y);lineto(x+15,y);
	setlinestyle(USERBIT_LINE,b,NORM_WIDTH);
	moveto(x+16,y);lineto(x+31,y);
	setlinestyle(USERBIT_LINE,c,NORM_WIDTH);
	moveto(x+32,y);lineto(x+47,y);y++;
	};
setlinestyle(USERBIT_LINE,0xFFFF,NORM_WIDTH);
return;}


/* ----------------------------------------------------------------------- */
