/*
tc-01.c AUTOMATIC MONITOR CONFIGURATION PROGRAM

This program invokes the highest resolution graphics mode
which is permitted on your hardware.  Supports MCGA, CGA,
EGA, and VGA.
*/

/* INCLUDE FILES */
#include <bios.h>
#include <stdio.h>
#include <graphics.h>
#include <process.h>

/* DECLARATIONS */

/* declare global variables */
int	C0=0,C1=1,C2=2,C3=3,C4=4,C5=5,
		C6=6,C7=7,C8=8,C9=9,C10=10,C11=11,
		C12=12,C13=13,C14=14,C15=15,mode_flag=0;
float	x_res,y_res;
float	sx,sy;
int	t1=1;

/* declare global subroutines */
void keyboard(void); void quit_pgm(void); void graphics_setup(void);

/* MAIN ROUTINE */
main ()
{
graphics_setup();
for (t1=1;t1!=2; ) keyboard ();
quit_pgm();
}

/* SUBROUTINE: CHECK THE KEYBOARD BUFFER */
void keyboard(void)
{
if (bioskey(1)==0) return; else quit_pgm();
}

/* SUBROUTINE: GRACEFUL EXIT FROM PROGRAM */
void quit_pgm(void)
{
cleardevice();restorecrtmode();exit(0);
}

/* SUBROUTINE: COMPATIBILITY MODULE */
void graphics_setup(void)
{
int graphics_adapter,graphics_mode;
detectgraph(&graphics_adapter,&graphics_mode);
if (graphics_adapter==VGA) goto VGA_mode;
if (graphics_mode=EGAHI) goto EGA_ECD_mode;
if (graphics_mode=EGALO) goto EGA_SCD_mode;
if (graphics_adapter=CGA) goto CGA_mode;
if (graphics_adapter=MCGA) goto CGA_mode;
goto abort_message;

VGA_mode:
graphics_adapter=VGA;graphics_mode=VGAHI;
initgraph(&graphics_adapter,&graphics_mode,"");
x_res=640;y_res=480;mode_flag=1;
setcolor(C7);outtextxy(240,472,"640*480 16-color VGA mode");
return;

EGA_ECD_mode:
graphics_adapter=EGA;graphics_mode=EGAHI;
initgraph(&graphics_adapter,&graphics_mode,"");
x_res=640;y_res=350;mode_flag=2;
setcolor(C7);outtextxy(240,342,"640*350 16-color EGA mode");
return;


EGA_SCD_mode:
graphics_adapter=EGA;graphics_mode=EGALO;
initgraph(&graphics_adapter,&graphics_mode,"");
x_res=640;y_res=200;mode_flag=3;
setcolor(C7);outtextxy(240,192,"640*200 16-color EGA mode");
return;



CGA_mode:
graphics_adapter=CGA;graphics_mode=CGAC3;
initgraph(&graphics_adapter,&graphics_mode,"");
x_res=320;y_res=200;C0=0,C1=3,C2=3,C3=3,C4=3,C5=3,C6=3,C7=3;
C8=2,C9=1,C10=3,C11=1,C12=3,C13=1,C14=3,C15=3,mode_flag=4;
setcolor(C7);outtextxy(64,192,"320*200 4-color CGA mode");
return;

abort_message:
printf("\n\nUnable to proceed.\n");
printf("Requires MCGA,CGA,EGA, or VGA adapter\n");
printf("  with appropriate monitor.\n");
printf("Please refer to the book.\n\n");
exit(0);
}
