#include <dos.h>
#include <stddef.h>
#include <conio.h>
#include <alloc.h>
#include <mem.h>
#include <string.h>

#define TRUE 1
#define FALSE 0

struct border_type {
	unsigned char	topbottom_char;
	unsigned char	side_char;
	unsigned char	upperleft_char;
	unsigned char	upperright_char;
	unsigned char	lowerleft_char;
	unsigned char	lowerright_char;
};

enum {
	NOBORDER = -1,
	SINGLEBORDER,
	DOUBLEBORDER,
	MAXBORDER,
};

struct border_type borders [] = {
	{ 0xC4, 0xB3, 0xDA, 0xBF, 0xC0, 0xD9 },
	{ 0xCD, 0xBA, 0xC9, 0xBB, 0xC8, 0xBC },
};

struct windowdef {
	int		state;
	int		x1;
	int		y1;
	int		x2;
	int		y2;
	int		border;
	int		bordercolor;
	int		windowcolor;
	int		prevx;
	int		prevy;
	int		savearealen;
	void		*savearea;
	struct windowdef*prevwind;
	struct windowdef*nextwind;
};

enum {
	CLOSE = 0,
	OPEN,
	HIDDEN,
};

#define Attr(fore,back) ((fore) | ((back) << 4))

struct windowdef defaultwind = {
	OPEN, 1, 1, 80, 25, FALSE, 0, Attr(LIGHTGRAY,BLACK), 0, 0, 0,
	NULL, NULL, NULL,
};

struct windowdef *activewind = &defaultwind;

void *getmem(int size)
{
	if (coreleft() < size)
        	return NULL;

        return malloc(size);
}

void drawbox(int x1, int y1, int x2, int y2, int bordercolor, int bordertype)
{
int temp;
unsigned *iptr, linebuf[80];
struct border_type *border;

	iptr = linebuf;
	border = &borders [bordertype];

	_DH = bordercolor;
	_DL = border->upperleft_char;
	*iptr++ = _DX;
	_DL = border->topbottom_char;
	for (temp = x2 - x1 - 1; temp; temp--)
		*iptr++ = _DX;
	_DL = border->upperright_char;
	*iptr = _DX;
	puttext(x1, y1, x2, y1, linebuf);

	_DH = bordercolor;
	_DL = border->lowerleft_char;
	*linebuf = _DX;
	_DL = border->lowerright_char;
	*iptr = _DX;
	puttext(x1, y2, x2, y2, linebuf);

	_DH = bordercolor;
	_DL = border->side_char;
	*linebuf = _DX;
	for (temp = y1 + 1; temp < y2; temp++) {
		puttext(x1, temp, x1, temp, linebuf);
		puttext(x2, temp, x2, temp, linebuf);
	}
}

struct windowdef *openwindow(int x1, int y1, int x2, int y2, int bordertype,
			     int bordercolor, int windowcolor,
			     const char *banner)
{
int temp;
struct text_info info;
struct windowdef *w;

	gettextinfo(&info);
	if (	(x1 < 1 || x1 > x2 || x2 > info.screenwidth)	  ||
		(y1 < 1 || y1 > y2 || y2 > info.screenheight)	  ||
		(bordertype > MAXBORDER || bordertype < NOBORDER) ||
		(bordercolor > 255 || windowcolor > 255)
           )
	return NULL;

	if ((w = getmem(sizeof(struct windowdef))) == NULL)
        	return w;

	w->savearealen = temp = (x2 - x1 + 1) * (y2 - y1 + 1) * 2;

	if ((w->savearea = getmem(temp)) == NULL) {
		free(w);
		return NULL;
	}

	gettext(x1, y1, x2, y2, w->savearea);

	w->x1 = x1;
	w->y1 = y1;
	w->x2 = x2;
	w->y2 = y2;
	w->bordercolor = bordercolor;
	w->windowcolor = windowcolor;

	if (bordertype == NOBORDER)
		w->border = FALSE;
	else {
		w->border = TRUE;
		drawbox(x1, y1, x2, y2, bordercolor, bordertype);
		if ((temp = strlen(banner)) != 0) {
			window(1, 1, 80, 25);
			gotoxy((x2+x1-temp)/2, y1);
                        textattr(bordercolor);
			cputs(banner);
		}
	}

	_DX = w->border;
	window(x1 + _DX, y1 + _DX, x2 - _DX, y2 - _DX);
	textattr(windowcolor);
	clrscr();

	w->nextwind = NULL;
	w->prevwind = activewind;
	activewind->nextwind = w;
	activewind->windowcolor = info.attribute;

	w->prevx = info.curx;
	w->prevy = info.cury;

	w->state = OPEN;

	return activewind = w;
}

int swapwindow(struct windowdef *w)
{
int size;
void *temp;
struct text_info info;

	if (!w || (w->state == OPEN && w != activewind))
		return FALSE;

	if ((temp = getmem(size = w->savearealen)) == NULL)
		return FALSE;

	gettextinfo(&info);
	gettext(w->x1, w->y1, w->x2, w->y2, temp);
	puttext(w->x1, w->y1, w->x2, w->y2, w->savearea);
	movmem(temp, w->savearea, size);

	if (w->state == HIDDEN) {
		w->state = OPEN;
		w->prevwind->nextwind = w->nextwind;
		if (w->nextwind)
			w->nextwind->prevwind = w->prevwind;
		w->nextwind = activewind->nextwind;
		w->prevwind = activewind;
		activewind->nextwind = w;
		activewind = w;
	} else {
		w->state = HIDDEN;
		activewind = w->prevwind;
		w->windowcolor = info.attribute;
	}

	_DX = activewind->border;
	window(	activewind->x1 + _DX, activewind->y1 + _DX,
		activewind->x2 - _DX, activewind->y2 - _DX);
	textattr(activewind->windowcolor);

	gotoxy(w->prevx, w->prevy);
	w->prevx = info.curx;
	w->prevy = info.cury;

	free(temp);

	return TRUE;
}

int hidewindow(struct windowdef *w)
{
	if (w->state != OPEN)
		return NULL;

	return swapwindow(w);
}

int showwindow(struct windowdef *w)
{
	if (w->state != HIDDEN)
		return NULL;

	return swapwindow(w);
}

int movewindow(struct windowdef *w, int x, int y)
{
struct text_info info;

	if (!w)
		return FALSE;

	gettextinfo(&info);
	if (	(x + (w->x2 - w->x1) > info.screenwidth)	||
		(y + (w->y2 - w->y1) > info.screenheight) )
		return FALSE;

	if (!hidewindow(w))
		return FALSE;

	w->x2 += x - w->x1;
	w->y2 += y - w->y1;
	w->x1 = x;
	w->y1 = y;

	return showwindow(w);
}

int closewindow(struct windowdef *w)
{
int ret;

	if ((ret = hidewindow(w)) == TRUE) {
		free(w->savearea);
		free(w);
	}

	return ret;
}

void printmessage(const char *s)
{
int i;

	delay(400);
	for (i = 0; i < 100; i++)
		cputs(s);
	delay(500);
}

void main(void)
{
struct windowdef *window1;
struct windowdef *window2;
struct windowdef *window3;

	window1 = openwindow(5, 5, 40, 18, SINGLEBORDER,
		Attr(BLUE,GREEN), Attr(BLACK,GREEN), "Window1");
        printmessage("Window 1... ");

	window2 = openwindow(8, 8, 43, 21, SINGLEBORDER,
		Attr(RED,BLACK), Attr(LIGHTGRAY,BLACK), "");
	printmessage("Window 2... ");

	window3 = openwindow(11, 11, 46, 24, SINGLEBORDER,
		Attr(YELLOW,RED), Attr(WHITE,RED), "Window3");
	printmessage("Window 3... ");

	hidewindow(window3);
        printmessage("Window 2...");

	hidewindow(window2);
	printmessage("Window 1... ");

        showwindow(window3);
	printmessage("Window 3... ");

        showwindow(window2);
        printmessage("Window 2... ");

	movewindow(window2,35,3);
	printmessage("Window 2... ");

	closewindow(window2);
	printmessage("Window 3... ");

        closewindow(window3);
        printmessage("Window 1... ");

        closewindow(window1);
	delay(500);
}

