#pragma inline

unsigned char cdecl __inportb__(int portid);
void cdecl __outportb__ (int portid, unsigned char value);
#define inp(portid) __inportb__(portid)
#define outp(portid,v) __outportb__(portid,v)

#define inqsize (24576)

unsigned char *inqh,*inqt;
unsigned char inq[inqsize];
unsigned char *inend;
unsigned int inqcnt;

extern void *malloc(unsigned int);

unsigned int base=0x3f8;
unsigned char intnum=12;	/* COM1 interrupt vector # */
unsigned char intmask=0x10;	/* bit mask for 8259. */

#define tval (*(unsigned long far *)0x0040006cl)

void cputc(c)
unsigned char c;
{
	unsigned long ov;

	ov=tval;
	while(!(inp(base+5)&0x20) || !(inp(base+6)&0x10))
	{
		if((tval-ov)>2000)	/* about 10 seconds timeout */
		{
			sput("\r\nCOM Port not responding\r\n");
			exit(1);
		}
	}
	outp(base,c);
}

getcom()
{
	int c;

	if(inqcnt)
	{
		c=*inqt++;
		if(inqt>=inend)
			inqt=inq;
		--inqcnt;
		return c;
	}
	return -1;
}

cgetc(count10)
unsigned int count10;
{
	unsigned long ov;

	count10<<=1;
	ov=tval;
	while((tval-ov)<count10)
	{
		if(inqcnt)
			return getcom();
	}
	return -1;
}

unsigned long vecsave;
unsigned char intrreg,intrchp,savp;

cominit(baud,port)
unsigned int baud;
unsigned char port;
{
	inqh=inqt=inq;
	inend=inq+inqsize;
	inqcnt=0;
	if(port==1)
	{
		base=0x3f8;
		intnum=12;
		intmask=0x10;
	}
	else	/* if using COM2, adjust I/O ports, and Int vectors */
	{
		base=0x2f8;
		intnum=11;
		intmask=0x8;
	}
	asm mov cs:dataadd,ds	/* mov 'C' dataseg address to var. */
	asm mov ah,35h		/* ask DOS for current int vector */
	asm mov al,intnum
	asm int 21h
	asm mov word ptr vecsave,bx
	asm mov word ptr vecsave+2,es
	asm mov ah,25h		/* ask DOS to set new int vector */
	asm mov al,intnum
	asm push ds
	asm mov dx,cs
	asm mov ds,dx
	asm mov dx,offset intsr	/* addr of interupt service in DS:DX */
	asm int 21h
	asm pop ds
	asm cli
	intrreg=inp(base+1);	/* sav contents of interupt enable reg. */
	outp(base+1,0);	/* disable interupts for now */
	intrchp=inp(0x21);
	outp(0x21,intrchp&~intmask);
	savp=inp(base+3);	/* save data, stop, parity */
	if(baud)
	{
		outp(base+3,0x80);
		asm mov dx,1
		asm mov ax,0c200h
		asm div word ptr baud
		asm mov baud,ax
		outp(base,baud);	/* output new baud to divisor latch */
		outp(base+1,baud>>8);
	}
	outp(base+3,3);	/* set 8 data, 1 stop, no parity */
	outp(base+4,0xb);	/* turn on DTR, RTS and enable ints */
	outp(0x20,0x20);	/* send EOI to 8259 */
	inp(base);
	outp(base+1,1);	/* now turn on 8250 interupts */
	asm sti
	asm pop bp
	asm ret

	asm dataadd dw 0

	asm intsr: push  ds
	asm push ax
	asm push dx
	asm push bx
	asm mov ds,dataadd
	asm mov ax,inqcnt
	asm cmp ax,inqsize
	asm jae overflow
	asm mov dx,base
	asm in al,dx
	asm mov bx,inqh
	asm mov [bx],al
	asm inc bx
	asm cmp bx,inend
	asm jb okinqh
	asm mov bx,offset inq
okinqh:
	asm mov inqh,bx
	asm inc inqcnt
overflow:
	asm mov al,020h 	/* send EOI to 8259 */
	asm out 20h,al
	asm pop bx
	asm pop dx
	asm pop ax
	asm pop ds
	asm iret
}

comrest()
{
	asm cli
	outp(base+1,intrreg);
	outp(0x21,intrchp);
	outp(base+3,savp);
	asm sti
	asm mov ah,25h
	asm mov al,intnum
	asm push ds
	asm lds dx,dword ptr vecsave
	asm int 21H
	asm pop ds
}


