#pragma inline

int open(char *fname)
{
	asm mov dx,fname
	asm mov al,0
	asm mov ah,3dh
	asm int 21h
	asm jc err
	return _AX;
err:	return 0;
}

int create(char *fname)
{
	asm mov dx,fname
	asm mov cx,0
	asm mov ah,3ch
	asm int 21h
	asm jc err
	return _AX;
err:	return 0;
}

#define MAXTRAN	(32768)		/* maximum bytes transfered with 1 dos call */

unsigned int zread(int fs,unsigned char *buf,unsigned int cnt)
{
	asm mov ax,ds
	asm mov es,ax
	asm mov bx,fs
	asm mov dx,buf
	asm mov cx,cnt
	asm mov ah,3fh
	asm int 21h
	return _AX;
}

long read(int fs,long lcount,unsigned char *buf)
{
	long total;
	unsigned int bcnt;

	total=0;
	while(lcount>MAXTRAN)
	{
		bcnt=zread(fs,buf,MAXTRAN);
		total+=bcnt;
		if(bcnt!=MAXTRAN)
			return total;
	}
	bcnt=zread(fs,buf,(unsigned int)lcount);
	return total+bcnt;
}

unsigned int zwrite(int fs,unsigned char *buf,unsigned int cnt)
{
	asm mov ax,ds
	asm mov es,ax
	asm mov bx,fs
	asm mov dx,buf
	asm mov cx,cnt
	asm mov ah,40h
	asm int 21h
	return _AX;
}

long write(int fs,long lcount,unsigned char *buf)
{
	long total;
	unsigned int bcnt;

	total=0;
	while(lcount>MAXTRAN)
	{
		bcnt=zwrite(fs,buf,MAXTRAN);
		total+=bcnt;
		if(bcnt!=MAXTRAN)
			return total;
	}
	bcnt=zwrite(fs,buf,(unsigned int)lcount);
	return total+bcnt;
}

#pragma warn -rvl

long lseek(int fs,long pos,int mode)
{
	asm mov bx,fs
	asm mov dx,pos
	asm mov cx,pos+2
	asm mov al,mode
	asm mov ah,42h
	asm int 21h
}

void close(int fs)
{
	asm mov bx,fs
	asm mov ah,3eh
	asm int 21h
}

putchar(chr)
unsigned char chr;
{
	asm mov bx,1
	asm mov cx,1
	asm lea dx,chr
	asm mov ah,40h
	asm int 21h
}

sput(str)
char *str;
{
	asm mov ax,ds
	asm mov es,ax
	asm mov dx,str
	asm mov di,dx
	asm mov al,0
	asm mov cx,-1
	asm cld 
	asm repnz scasb
	asm not cx
	asm dec cx
	asm mov bx,1
	asm mov ah,40h
	asm int 21h
}

static unsigned char flg,chr;

int chkkbd()
{
	asm mov al,flg 
	asm or al,al
	asm jnz alredy  
	asm mov ah,1
	asm int 16h
	asm sti
	asm jz nochr  
	asm mov ah,0
	asm int 16h
	asm or al,al
	asm jnz okch
	asm inc flg
	asm mov al,ah
okch:	asm mov chr,al 
	asm inc flg  
alredy:	return 1;
nochr:	return 0;
}

int getkey()
{
kbdlp:	asm call chkkbd  
	asm or ax,ax
	asm jz kbdlp  
	asm mov al,0
	asm dec flg
	asm jnz func
	asm mov al,chr 
func:	return _AX;
}

int fgetkey()
{
	int c;

	if(!(c=getkey()))
		c=getkey()|256;
	return c;
}

void putint(num,nlen)
register unsigned int num;
int nlen;
{
register char *pnt;
	char buf[6];

	pnt=buf+sizeof(buf);
	*--pnt=0;
	do
	{
		*--pnt=num%10+'0';	/* next digit */
		num/=10;
		--nlen;
	} while(num);
	while(nlen--)
		*--pnt=' ';
	sput(pnt);
}

void putlint(num,nlen)
unsigned long num;
register int nlen;
{
register char *pnt;
	char buf[11];

	pnt=buf+sizeof(buf);
	*--pnt=0;
	do
	{
		*--pnt=num%10+'0';	/* next digit */
		num/=10;
		--nlen;
	} while(num);
	while(nlen--)
		*--pnt=' ';
	sput(pnt);
}

