//  ECOSYSTEM SIMULATION PROGRAM
//      zipper.h    2.00  07-Aug-1990
//      Borland Turbo C++ 1.0
//
//      Zipper class definition
//
//      Written by Scott Robert Ladd

#if !defined(ZIPPER_H)
#define ZIPPER_H

#include "creature.h"

class Zipper : public Creature
    {
    public:
        // basic constructor
        Zipper(int x, int y);

        // copy constructor (used in birth of a new Zipper)
        Zipper(const Zipper & Z);

        // destructor
        virtual ~Zipper();

        // get creature's species
        virtual CreatureSpecies Species()
            {
            return CS_ZIPPER;
            }

        // ask Zipper to do something
        virtual MoveResult Move();

        // tell Zipper to draw itself
        virtual void Draw();

        // tell Zipper to erase itself
        virtual void Erase();

    protected:
        int TurnGene;                  // number of moves before a turn
        int MoveCount;                 // number of moves since last turn
        int Direction;                 // currently selected direction

        static const int Size;         // size of a zipper
        static const int Color;        // color of Zippers
        static const int DiagMoveCost; // energy cost to move diagonally
        static const int OrthMoveCost; // energy cost to move orthagonally
        static const int FoodValue;    // energy obtained from eating food
        static const int MaxTurnGene;  // maximum movement gene value
        static const int MinTurnGene;  // minimum movement gene value
        static const int RepEnergy;    // energy required for reproduction
    };

#endif
