//  WINDOW (TEXT) LIBRARY
//      wdwword.h      v1.00   11-Jul-1990
//      Turbo C++ 1.0
//
//      A class defining a single display word
//
//      Written by Scott Robert Ladd.

#if !defined(WDWWORD_H)
#define WDWWORD_H

class WdwWord
    {
    public:
        WdwWord();

        void Put(unsigned char attr, char sym);

        void Put(unsigned short word);

        void Get(unsigned char & attr, char & sym);

        unsigned short Get();

    private:
        union
            {
            unsigned short AsWord;

            struct
                {
                char Symbol;
                unsigned char Attribute;
                }
                AsParts;
            };
    };

inline WdwWord::WdwWord()
    {
    AsParts.Attribute = 7;
    AsParts.Symbol    = ' ';
    }

inline void WdwWord::Put(unsigned char attr, char sym)
    {
    AsParts.Attribute = attr;
    AsParts.Symbol    = sym;
    }

inline void WdwWord::Put(unsigned short word)
    {
    AsWord = word;
    }

inline void WdwWord::Get(unsigned char & attr, char & sym)
    {
    attr = AsParts.Attribute;
    sym  = AsParts.Symbol;
    }

inline unsigned short WdwWord::Get()
    {
    return AsWord;
    }

#endif
