//  WINDOW (TEXT) LIBRARY
//      wdwbuffer.cpp     v1.00   11-Jul-1990
//      Turbo C++ 1.0
//
//      Class definition for a window buffer
//
//      Written by Scott Robert Ladd.

#include "stdlib.h"
#include "string.h"
#include "wdw.h"
#include "wdwbuffe.h"

WdwBuffer::WdwBuffer()
    {
    RowSize = 0;
    ColSize = 0;

    Buffer  = NULL;
    }

WdwBuffer::WdwBuffer(const WdwBuffer & wb)
    {
    if (wb.Buffer == NULL)
        {
        RowSize = 0;
        ColSize = 0;

        Buffer  = NULL;
        }

    RowSize = wb.RowSize;
    ColSize = wb.ColSize;

    Buffer = new WdwWord [RowSize * ColSize];

    memcpy(Buffer,wb.Buffer,RowSize * ColSize * sizeof(WdwWord));

    if (Buffer == NULL)
        Window::Error("Unable to allocate buffer space");
    }

WdwBuffer::~WdwBuffer()
    {
    delete Buffer;
    }

void WdwBuffer::SetSize(unsigned short rows, unsigned short cols)
    {
    RowSize = rows;
    ColSize = cols;

    if (Buffer != NULL)
        delete Buffer;

    Buffer = new WdwWord [rows * cols];

    if (Buffer == NULL)
        Window::Error("Unable to allocate buffer space");
    }

void WdwBuffer::Fill(unsigned char attr, char sym)
    {
    if (Buffer == NULL)
        return;

    unsigned short r, c;

    for (r = 0; r < RowSize; ++r)
        {
        for (c = 0; c < ColSize; ++c)
            {
            Buffer[r * ColSize + c].Put(attr,sym);
            }
        }
    }
