//  USER-DEFINED STREAM MANIPULATORS
//      userman.cpp   1.00    04-Aug-1990
//      Turbo C++ 1.0
//
//      ANSI.SYS stream I/O manipulators
//
//      Written by Scott Robert Ladd

#include "iostream.h"
#include "iomanip.h"
#include "conio.h"

//------------------------------------------------
// simple manipulator
//------------------------------------------------

ostream & ANSIclear(ostream & o)
    {
    return o << "\x1B[2J";
    }

//------------------------------------------------
// manipulator with single int parameter
//
// this example is commented out to avoid conflict
// with the definition of the ANSIsetmode manipulator
// below, which uses an enumerated type for its
// mode value
//------------------------------------------------

/*
ostream & ANSIsetmode(ostream & o, int mode)
    {
    return o << "\x1B[" << mode << "h";
    }

OMANIP(int) ANSIsetmode(int mode)
    {
    return OMANIP(int) (ANSIsetmode, mode);
    }
*/

//----------------------------------------------------
// manipulator with single non-int, non-long parameter
//----------------------------------------------------

enum ANSImode {ANSI_40x25_BW, ANSI_40x25_Color,
               ANSI_80x25_BW, ANSI_80x25_Color};

ostream & ANSIsetmode2(ostream & o, ANSImode mode)
    {
    return o << "\x1B[" << (int)mode << "h";
    }

IOMANIPdeclare(ANSImode);

OAPP(ANSImode) ANSIsetmode(ANSIsetmode2);

//---------------------------------------------------
// manipulator w/ two parameters!
//---------------------------------------------------

struct ANSIcoord
    {
    int l, c;
    };

IOMANIPdeclare(ANSIcoord);

ostream & ANSIsetpos (ostream & o, ANSIcoord p)
    {
    return o << "\x1B[" << p.l << ';' << p.c << 'H';
    }

OMANIP(ANSIcoord) ANSIsetpos(int line, int col)
    {
    ANSIcoord p;

    p.l = line;
    p.c = col;

    return OMANIP(ANSIcoord)(ANSIsetpos,p);
    }

//-------------------------------------------------
// main program to test the above manipulators!
//-------------------------------------------------

int main()
    {
    OAPP(ANSImode) ANSIsetmode = ANSIsetmode2;

    cout << ANSIclear;
    cout << ANSIsetmode(ANSI_40x25_Color);
    cout << "Hello!";

    while (!kbhit()) ;
    if (!getch()) getch();

    cout << ANSIsetmode(ANSI_80x25_Color);
    cout << "Hello!";

    while (!kbhit()) ;
    if (!getch()) getch();

    cout << ANSIsetpos(10,10) << "Hello, world!";
    cout << ANSIsetpos(20,1);

    return 0;
    }
