;   SCREEN CLASS
;       ScrnDOS4    2.00    02-Aug-1990
;       Turbo Assembler v2.0
;
;       Provides functions for saving/restoring MS-DOS 4.x screen information.
;
;       Written by Scott Robert Ladd

.8086

IFDEF LMOD
    .MODEL LARGE,C
    %OUT "Large Model"
ELSEIFDEF CMOD
    .MODEL COMPACT,C
    %OUT "Compact Model"
ELSEIFDEF MMOD
    .MODEL MEDIUM,C
    %OUT "Medium Model"
ELSE
    .MODEL SMALL,C
    %OUT "Small Model"
ENDIF

.CODE

PUBLIC SaveConData
PUBLIC RestoreConData

SaveConData PROC USES DS, dataPtr:PTR

            mov     bx,0           ; console device handle

            mov     ax,440Ch       ; MS-DOS IOCTL function, generic I/O control
            mov     cx,037Fh       ; Get Display Information for console

            IF @DataSize
                lds     dx,dataPtr ; move data pointer into DS:DX
            ELSE
                mov     dx,dataPtr ; move data pointer into DX
            ENDIF

            int     21h            ; call MS-DOS

            jc      GCDP_error     ; if carry is set, we have an error

            mov     ax,0           ; "okay" status
            ret                    ; outa here!

GCDP_error: mov     ax,1           ; "error" status
            ret                    ; outa here!

SaveConData ENDP

RestoreConData PROC USES DS, dataPtr:PTR

            mov     bx,1           ; console device handle

            mov     ax,440Ch       ; MS-DOS IOCTL function, generic I/O control
            mov     cx,035Fh       ; Set Display Information for console

            IF @DataSize
                lds     dx,dataPtr ; move data pointer into DS:DX
            ELSE
                mov     dx,dataPtr ; move data pointer into DX
            ENDIF

            int     21h            ; call MS-DOS

            jc      RCDP_error     ; if carry is set, we have an error

            mov     ax,0           ; "okay" status
            ret                    ; outa here!

RCDP_error: mov     ax,1           ; "error" status
            ret                    ; outa here!

RestoreConData ENDP

END
