//  SCREEN CLASS
//      scrnctdt.cpp  v3.20   13-Jul-1990
//      Turbo C++ 1.0
//
//      Static member initializations, constructor, and destructor.
//
//      Written by Scott Robert Ladd. Released into the public domain.

#pragma inline

#include "screen.h"

// assign values to static class members

ScrType        Screen::VideoType    = SCR_TYPE_UNKNOWN;
ScrMode        Screen::VideoMode    = SCR_MODE_UNKNOWN;
ScrMode        Screen::OriginalMode = SCR_MODE_UNKNOWN;
ScrAccess      Screen::AccessMode   = SCR_ACC_DIRECT;
unsigned short Screen::Width        = 0;
unsigned short Screen::Length       = 0;
unsigned short Screen::CursorShape  = 0;
short          Screen::CursorHidden = 0;
unsigned short Screen::HowMany      = 0;
short *        Screen::SavedScreen  = NULL;
unsigned short Screen::SavedCursPos = 0;
short          Screen::SavedCursShp = 0;
ConsoleData *  Screen::SavedConData = NULL;

unsigned short far * Screen::VideoMem = (unsigned short far *)0L;

static Screen Initializer;

// constructor
Screen::Screen()
    {
    ++HowMany;

    if (HowMany > 1)
        return;

    // save MS-DOS 4.x information, if need be
    _AX = 0x3000;
    geninterrupt(0x21);

    if (_AL >= 4)
        {
        SavedConData = new ConsoleData;

        if (SavedConData == NULL)
            {
            _AX = 0x4C01;
            geninterrupt(0x21);
            }
        }

    short i, status_changed;
    unsigned char orig_status;

    // Attempt to identify the type of video adapter installed.
    // Call VGA "Identify Adapter Service" first

    _AH = 0x1A;
    _AL = 0;
    geninterrupt(0x10);

    if (_AL == 0x1A)
        {
        switch (_BL)
            {
            case 1 :
                VideoType = SCR_TYPE_MDA;
                break;

            case 2 :
                VideoType = SCR_TYPE_CGA;
                break;

            case 4 :
            case 5 :
                VideoType = SCR_TYPE_EGA;
                break;

            case 7 :
            case 8 :
                VideoType = SCR_TYPE_VGA;
                break;

            case 10:
            case 11:
            case 12:
                VideoType = SCR_TYPE_MCGA;
                break;

            default:
                VideoType = SCR_TYPE_UNKNOWN;
            }
        }
    else
        {
        // VGA services not available -- maybe it's EGA

        _AH = 0x12;
        _BL = 0x10;
        geninterrupt(0x10);

        // if BL is not 0x10, we have an EGA

        if (_BL != 0x10)
            VideoType = SCR_TYPE_EGA;
        else
            {
            // check two-bit "monitor type" setting in equipment word

            geninterrupt(0x11);

            switch ((_AL & 0x30) >> 4)
                {
                case 0 :
                    VideoType = SCR_TYPE_UNKNOWN;

                case 1 :
                case 2 :
                    VideoType = SCR_TYPE_CGA;
                    break;

                case 3 :
                    // if we have a mono adapter, a Hercules can be
                    // differentiated from an MDA by seeing if the high bit
                    // of the status register changes

                    status_changed = 0;

                    orig_status = (unsigned char)(inp(0x03BA) & 0x80);

                    for (i = 0; (i < 30000) && (!status_changed); ++i)
                        if (orig_status != (unsigned char)(inp(0x03BA) & 0x80))
                            status_changed = 1;

                    if (status_changed)
                        VideoType = SCR_TYPE_HGC;
                    else
                        VideoType = SCR_TYPE_MDA;
                }
            }
        }

    // store the segment of video memory

    if ((VideoType == SCR_TYPE_MDA) || (VideoType == SCR_TYPE_HGC))
        VideoMem = (unsigned short far *)MK_FP(0xB000,0);
    else
        VideoMem = (unsigned short far *)MK_FP(0xB800,0);

    // save the original cursor shape

    _AH = 3;
    _BH = 0;
    geninterrupt(0x10);

    SavedCursShp = _CX;
    SavedCursPos = _DX;

    // find width of the orginal screen

    _AH = 0x0F;
    geninterrupt(0x10);

    Width = _AH;

    // find length of the orginal screen

    asm push bp
    asm mov  ax,1130H
    asm mov  bh,0
    asm mov  dx,0
    asm int  10H
    asm pop  bp

    Length = _DX + 1;

    if (Length == 1)
        Length = 25;

    // now, allocate a buffer to hold the original screen contents...

    SavedScreen = new short [Length * Width];

    // ...and save the original screen

    if (SavedScreen != NULL)
        for (i = 0; i < Length * Width; i++)
            SavedScreen[i] = VideoMem[i];

    // make note of the original screen mode

    switch (Width)
        {
        case 40:
            OriginalMode = SCR_MODE_25x40;
            break;

        case 80:
            switch (Length)
                {
                case 25:
                    OriginalMode = SCR_MODE_25x80;
                    break;
                case 30:
                    OriginalMode = SCR_MODE_30x80;
                    break;
                case 43:
                    OriginalMode = SCR_MODE_43x80;
                    break;
                case 50:
                    OriginalMode = SCR_MODE_50x80;
                }
        }

    // if we have an identifiable screen mode, make it the current mode

    if (OriginalMode != -1)
        VideoMode = OriginalMode;

    // mark the cursor as visible

    CursorHidden = 0;
    }

// destructor
Screen::~Screen()
    {
    --HowMany;

    if (HowMany > 0)
        return;

    short i;

    // reset to orginal mode

    if ((OriginalMode != VideoMode) && (OriginalMode != SCR_MODE_UNKNOWN))
        SetMode(OriginalMode);

    // restore MS-DOS 4.x information, if need be
    _AX = 0x3000;
    geninterrupt(0x21);

    if (_AL >= 4)
        delete SavedConData;

    // restore original screen contents

    if (SavedScreen != NULL)
        for (i = 0; i < Length * Width; i++)
            VideoMem[i] = SavedScreen[i];

    // restore original cursor shape

    _AH = 1;
    _CX = SavedCursShp;

    geninterrupt(0x10);

    // restore original cursor position

    _AH = 2;
    _BH = 0;
    _DX = SavedCursPos;

    geninterrupt(0x10);

    delete SavedScreen;
    }
