//  LONG BIT SET CLASS
//      lbitset.cpp    3.00    28-May-1990
//      Turbo C++ 1.0
//
//      Defines a set of bits
//
//      Written by Scott Robert Ladd

#include "lbitset.h"
#include "stddef.h"
#include "string.h"

// constructors
LongBitSet::LongBitSet(unsigned long size)
    {
    unsigned long alloc;

    Length = size;

    alloc = (size + 7UL) / 8UL;

    Data = new unsigned char[(unsigned int)alloc];

    memset(Data,'\x00',(unsigned int)alloc);
    }

LongBitSet::LongBitSet(const LongBitSet & bs)
    {
    unsigned long alloc;

    Length = bs.Length;

    alloc = (bs.Length + 7UL) / 8UL;

    Data = new unsigned char[(unsigned int)alloc];

    memcpy(Data,bs.Data,(unsigned int)alloc);
    }

// destructor
LongBitSet::~LongBitSet(void)
    {
    if (Data != NULL)
        delete Data;
    }

// assignment operator
void LongBitSet::operator = (const LongBitSet & bs)
    {
    unsigned long alloc;

    if (Length != bs.Length)
        {
        Length = bs.Length;

        alloc = (bs.Length + 7UL) / 8UL;

        if (Data != NULL)
            delete Data;

        Data = new unsigned char[(unsigned int)alloc];

        memcpy(Data,bs.Data,(unsigned int)alloc);
        }
    else
        memcpy(Data,bs.Data,(unsigned int)((Length + 7UL) / 8UL));
    }

// union operators
LongBitSet LongBitSet::operator & (const LongBitSet & bs)
    {
    LongBitSet result;

    unsigned long bit;

    if (Length < bs.Length)
        {
        result = bs;

        for (bit = 0UL; bit < Length; ++bit)
            if ((*this)[bit])
                result.Include(bit);
        }
    else
        {
        result = *this;

        for (bit = 0UL; bit < bs.Length; ++bit)
            if (bs[bit])
                result.Include(bit);
        }

    return result;
    }

LongBitSet LongBitSet::operator &= (const LongBitSet & bs)
    {
    *this = *this & bs;

    return *this;
    }

// synonyms for union operators
LongBitSet LongBitSet::operator + (const LongBitSet & bs)
    {
    LongBitSet result = *this & bs;

    return result;
    }

LongBitSet LongBitSet::operator += (const LongBitSet & bs)
    {
    LongBitSet result = *this &= bs;

    return result;
    }

// intersection operators
LongBitSet LongBitSet::operator | (const LongBitSet & bs)
    {
    LongBitSet result;

    unsigned long max;

    if (Length > bs.Length)
        {
        result = LongBitSet(Length);
        max    = bs.Length;
        }
    else
        {
        result = LongBitSet(bs.Length);
        max    = Length;
        }

    for (unsigned long bit = 0UL; bit < max; ++bit)
        if ((*this)[bit] & bs[bit])
            result.Include(bit);

    return result;
    }

LongBitSet LongBitSet::operator |= (const LongBitSet & bs)
    {
    *this = *this | bs;

    return *this;
    }

// difference operators
LongBitSet LongBitSet::operator - (const LongBitSet & bs)
    {
    LongBitSet result = *this;

    unsigned long stop = (Length < bs.Length) ? Length : bs.Length;

    for (unsigned long bit = 0UL; bit < stop; ++bit)
        if (bs[bit])
            result.Exclude(bit);

    return result;
    }

LongBitSet LongBitSet::operator -= (const LongBitSet & bs)
    {
    *this = *this - bs;

    return *this;
    }

// complement operator
LongBitSet LongBitSet::operator ~ ()
    {
    LongBitSet result(Length);

    for (unsigned long bit = 0UL; bit < Length; ++bit)
        if ((*this)[bit])
            result.Exclude(bit);
        else
            result.Include(bit);

    return result;
    }

// comparison operators
int LongBitSet::operator == (const LongBitSet & bs) const
    {
    if (Length != bs.Length)
        return 0;

    for (unsigned long bit = 0UL; bit < Length; ++bit)
        if ((*this)[bit] != bs[bit])
            return 0;

    return 1;
    }

int LongBitSet::operator != (const LongBitSet & bs) const
    {
    if (Length != bs.Length)
        return 1;

    unsigned long bit = 0UL;

    while (bit < Length)
        if ((*this)[bit] == bs[bit])
            ++bit;
        else
            return 1;

    return 0;
    }
