//  SHORT BIT SET CLASS
//      bstest.cpp  v1.00   04-Aug-1990
//      Turbo C++ 1.0
//
//      Test program
//
//      Written by Scott Robert Ladd

#include "sbitset.h"
#include "iostream.h"

void ShowShortBitSet(ShortBitSet & bs);

int main()
    {
    unsigned int i;

    ShortBitSet bs1(76);
    ShortBitSet bs2(13);
    ShortBitSet bs3(8);

    for (i = 0; i < bs1.Size(); ++i)
        {
        if (i % 2)
            bs1.Include(i);
        else
            bs1.Exclude(i);
        }

    ShowShortBitSet(bs1);

    bs3 = bs1;

    ShowShortBitSet(bs3);

    for (i = 0; i < bs2.Size(); ++i)
        {
        if (i % 2)
            bs2.Exclude(i);
        else
            bs2.Include(i);
        }

    for (i = 4; i < bs3.Size(); ++ i)
        {
        bs2.Exclude(i);
        }

    ShowShortBitSet(bs2);

    bs3 = bs2 + bs1;
    ShowShortBitSet(bs3);

    bs3 = ~bs2;
    ShowShortBitSet(bs3);

    bs2 = bs1 | bs3;
    ShowShortBitSet(bs2);

    bs2 -= bs3;
    ShowShortBitSet(bs2);

    bs2 = bs1 - bs3;
    ShowShortBitSet(bs2);

    bs3 += bs1;
    ShowShortBitSet(bs3);

    bs3.AllOn();
    ShowShortBitSet(bs3);

    bs3.AllOff();
    ShowShortBitSet(bs3);

    bs3 = bs2;

    if (bs3 == bs1)
        cout << "bs3 == bs1\n";

    if (bs3 == bs2)
        cout << "bs3 == bs2\n";

    if (bs3 != bs1)
        cout << "bs3 != bs1\n";

    if (bs3 != bs2)
        cout << "bs3 != bs2\n";
    }

void ShowShortBitSet(ShortBitSet & bs)
    {
    for (int i = 0; i < bs.Size(); ++i)
        if (bs[i])
            cout << '1';
        else
            cout << '0';

    cout << '\n';
    }
