//  POLYMORPHISM EXAMPLE
//      animals.cpp     1.00    04-Aug-1990
//      Turbo C++ 1.0
//
//      Non-polymorphic kennel management program
//
//      Written by Scott Robert Ladd

#include "stdio.h"
#include "stdlib.h"
#include "string.h"

class Animal
    {
    protected:
        char * Name;

    public:
        Animal()
            {
            Name = NULL;
            }

        Animal(char * n)
            {
            Name = strdup(n);
            }

        ~Animal()
            {
            delete Name;
            }

        void WhoAmI()
            {
            printf("generic animal");
            }
    };

class Cat : public Animal
    {
    public:
        Cat() : Animal() { /* empty */ }

        Cat(char * n)
            : Animal(n)
            { /* empty */ }

        void WhoAmI()
            {
            printf("I am a cat named %s\n",Name);
            }
    };

class Dog : public Animal
    {
    public:
        Dog() : Animal() { /* empty */ }

        Dog(char * n)
            : Animal(n)
            { /* empty */ }

        void WhoAmI()
            {
            printf("I am a dog named %s\n",Name);
            }
    };

class Kennel
    {
    private:
        unsigned int MaxCats;
        unsigned int NumCats;
        Cat ** Kitties;

        unsigned int MaxDogs;
        unsigned int NumDogs;
        Dog ** Doggies;

    public:
        Kennel(unsigned int maxc, unsigned int maxd);

        ~Kennel();

        unsigned int Accept(Dog * d);
        unsigned int Accept(Cat * c);

        Dog * ReleaseDog(unsigned int pen);
        Cat * ReleaseCat(unsigned int pen);

        void ListAnimals();
    };

Kennel::Kennel(unsigned int maxc, unsigned int maxd)
    {
    MaxCats = maxc;
    MaxDogs = maxd;

    NumCats = 0;
    NumDogs = 0;

    Kitties = new Cat * [MaxCats];
    Doggies = new Dog * [MaxDogs];

    for (int i = 0; i < MaxCats; ++i)
        Kitties[i] = NULL;

    for (i = 0; i < MaxDogs; ++i)
        Doggies[i] = NULL;
    }

Kennel::~Kennel()
    {
    delete Kitties;
    delete Doggies;
    }

unsigned int Kennel::Accept(Dog * d)
    {
    if (NumDogs == MaxDogs)
        return 0;

    ++NumDogs;

    int i = 0;

    while (Doggies[i] != NULL)
        ++i;

    Doggies[i] = d;

    return i + 1;
    }

unsigned int Kennel::Accept(Cat * c)
    {
    if (NumCats == MaxCats)
        return 0;

    ++NumCats;

    int i = 0;

    while (Kitties[i] != NULL)
        ++i;

    Kitties[i] = c;

    return i + 1;
    }

Dog * Kennel::ReleaseDog(unsigned int pen)
    {
    if (pen > MaxDogs)
        return NULL;

    --pen;

    if (Doggies[pen] != NULL)
        {
        Dog * temp = Doggies[pen];
        Doggies[pen] = NULL;
        --NumDogs;
        return temp;
        }
    else
        return NULL;
    }

Cat * Kennel::ReleaseCat(unsigned int pen)
    {
    if (pen > MaxCats)
        return NULL;

    --pen;

    if (Kitties[pen] != NULL)
        {
        Cat * temp = Kitties[pen];
        Kitties[pen] = NULL;
        --NumCats;
        return temp;
        }
    else
        return NULL;
    }

void Kennel::ListAnimals()
    {
    int i;

    if (NumDogs > 0)
        {
        for (i = 0; i < MaxDogs; ++i)
            if (Doggies[i] != NULL)
                {
                printf("The dog in pen %d says: ",i);
                Doggies[i]->WhoAmI();
                }
        }

    if (NumCats > 0)
        {
        for (i = 0; i < MaxCats; ++i)
            if (Kitties[i] != NULL)
                {
                printf("The cat in pen %d says: ",i);
                Kitties[i]->WhoAmI();
                }
        }
    }

Dog d1("Rover");
Dog d2("Spot");
Dog d3("Chip");
Dog d4("Buddy");
Dog d5("Butch");

Cat c1("Tinkerbell");
Cat c2("Inky");
Cat c3("Fluffy");
Cat c4("Princess");
Cat c5("Sylvester");

int main()
    {
    Kennel K(10,10); // max of ten cats and dogs

    // animals are brought in and taken out
    K.Accept(&d1);

    unsigned int c2pen = K.Accept(&c2);

    K.Accept(&d3);
    K.Accept(&c1);

    unsigned int d4pen = K.Accept(&d4);

    K.Accept(&d5);
    K.Accept(&c5);

    K.ReleaseCat(c2pen);

    K.Accept(&c4);
    K.Accept(&c3);

    K.ReleaseDog(d4pen);

    K.Accept(&d2);

    K.ListAnimals();
    }
