//  WINDOW (TEXT) LIBRARY
//      wtest.cpp   v1.00   12-Jul-1990
//      Turbo C++ 1.0
//
//      Test program
//
//      Written by Scott Robert Ladd.

#include "conio.h"
#include "wdw.h"
#include "screen.h"

int doit();
void Wait();
void MyHandler(const String & msg);

int main()
    {
    // for (int i = 0; i < 20; ++i)
        doit();

    return 0;
    }

int doit()
    {
    Screen::SetMode(SCR_MODE_50x80);

    // Window::SetErrorHandler(MyHandler);

    Window::SetWallpaper(SCR_F_BLUE|SCR_F_BRIGHT|SCR_B_BLUE,'\xB1');

    Window wmain(5,5,20,60,SCR_F_WHITE,BT_SINGLE,WDW_HS_CENTER,"[Main Window]",SCR_F_RED);
    Wait();

    Window * w2 = new Window (10,10,30,40,SCR_B_WHITE|SCR_F_BLACK,BT_DOUBLE,WDW_HS_LEFT,"[Window 2]",SCR_F_GREEN);
    w2->Store(10,0,SCR_B_WHITE|SCR_F_BLUE,"This is a very long string used to test clipping!");
    w2->Display();
    Wait();

    wmain.Store(2,0,0,"This string is in the MAIN WINDOW!");
    wmain.Display(2);
    Wait();

    w2->SetWrap(WDW_WM_ON);
    w2->Store(0,0,0,"This is a very long string used to test wrapping!");
    w2->StoreFormatted(5,0,0,"Tests %s output. %g 0x%x","formatted",3.14159,7654);
    w2->Store(20,0,0,"This is a very long string used to test clipping!");
    w2->Display();
    Wait();

    w2->SetBorderType(BT_SINGLE);
    Wait();

    w2->SetBorderAttr(SCR_F_BLACK|SCR_B_GREEN);
    Wait();

    w2->SetHeader(WDW_HS_RIGHT,"[New Window 2 Head]");
    Wait();

    w2->ScrollDown();
    w2->Display();
    Wait();

    w2->ScrollUp();
    w2->Display();
    Wait();

    w2->Clear(1);
    w2->Display();
    Wait();

    w2->Clear();
    w2->Display();
    Wait();

    Window * w3 = new Window (7,30,40,75,SCR_B_BLUE|SCR_F_WHITE,BT_SINGLE,WDW_HS_RIGHT,"[Window 3]",SCR_B_CYAN|SCR_F_BROWN|SCR_F_BRIGHT);
    Wait();

    w3->Store(0,0,0,"repainted all windows");
    wmain.Display();
    w2->Display();
    w3->Display();
    Wait();

    w2->Move(1,1);
    Wait();

    w2->Hoist();
    Wait();

    w3->Drop();
    Wait();

    delete w2;
    Wait();

    Window * w4 = new Window (20,10,45,70,SCR_B_RED|SCR_F_BROWN|SCR_F_BRIGHT,BT_DOUBLE,WDW_HS_CENTER,"[Window 4]",SCR_B_BROWN|SCR_F_WHITE);
    Wait();

    wmain.Hoist();
    Wait();

    delete w3;
    Wait();

    delete w4;
    Wait();

    return 0;
    }

void Wait()
    {
    while (!kbhit()) ;
    if (!getch()) getch();
    }

void MyHandler(const String & msg)
    {
    Screen::Put(0,0,112,msg);
    }
