//  WINDOW (TEXT) LIBRARY
//      wdwmisc.cpp     v1.00   11-Jul-1990
//      Turbo C++ 1.0
//
//      The Window class defines a basic window
//
//      Written by Scott Robert Ladd.

#include "conio.h"
#include "stdlib.h"
#include "wdw.h"

// error handler initialization and default function

void DefaultHandler(const String & msg);

void (* (Window::ErrorHandler))(const String &) = DefaultHandler;

void DefaultHandler(const String & msg)
    {
    Screen::Put(0, 0,112,"--> Window System Error: ");
    Screen::Put(0,25,112,msg);
    Screen::Put(1, 0,112,"--> Press any key to abort program...");

    while (!kbhit()) ;
    if (!getch()) getch();

    exit(1);
    }

void Window::SetErrorHandler(void (* userHandler)(const String & msg))
    {
    ErrorHandler = userHandler;
    }

void Window::Error(const String & msg)
    {
    ErrorHandler(msg);
    }

// move method
void Window::Move(unsigned short row, unsigned short col)
    {
    if ((EndRow <= row) || (EndCol <= col))
        return;

    if (BorderType != BT_NONE)
        if ((row == 0) || (row == ScreenRows)
        ||  (col == 0) || (col == ScreenCols))
            return;

    HomeRow = row;
    HomeCol = col;

    EndRow  = HomeRow + Length - 1;
    EndCol  = HomeCol  + Width  - 1;

    ResetWindows();
    }

// change level of window in the stack
void Window::Hoist()
    {
    List.Hoist(this);
    ResetWindows();
    }

void Window::Drop()
    {
    List.Drop(this);
    ResetWindows();
    }

// change / read wrapmode
WrapMode Window::WrapStatus()
    {
    return Wrap;
    }

void Window::SetWrap(WrapMode wm)
    {
    Wrap = wm;
    }

void Window::SetOwnership()
    {
    unsigned short row, col;

    if (BorderType != BT_NONE)
        {
        for (row = HomeRow - 1; row <= EndRow + 1; ++row)
            {
            for (col = HomeCol - 1; col <= EndCol + 1; ++col)
                {
                OwnerTable.SetOwner(row,col,this);
                }
            }
        }
    else
        {
        for (row = HomeRow; row <= EndRow; ++row)
            {
            for (col = HomeCol; col <= EndCol; ++col)
                {
                OwnerTable.SetOwner(row,col,this);
                }
            }
        }
    }

void Window::SetWallpaper(unsigned char attr, char sym)
    {
    WallpaperAttr   = attr;
    WallpaperSymbol = sym;
    }

void Window::DrawWallpaper()
    {
    unsigned short row, col;

    for (row = 0; row < ScreenRows; ++row)
        for (col = 0; col < ScreenCols; ++col)
            Screen::Put(row,col,WallpaperAttr,WallpaperSymbol);
    }

void Window::ResetWindows()
    {
    Window * w;

    w = List.AtBottom();

    DrawWallpaper();
    OwnerTable.Clear();

    while (w != NULL)
        {
        w->SetOwnership();
        w->Display();
        w = List.NextWindow();
        }
    }
