//  WINDOW (TEXT) LIBRARY
//      wdwdisp.cpp     v1.00   11-Jul-1990
//      Turbo C++ 1.0
//
//      Defintiions of display and cursor methods for Window class.
//
//      Written by Scott Robert Ladd.

#include "stdarg.h"
#include "stdio.h"
#include "wdw.h"

// cursor methods
void Window::PlaceCursor(unsigned short row, unsigned short col)
    {
    if ((row < Length) && (col < Width))
        {
        CursorRow = row;
        CursorCol = col;
        }
    }

void Window::UpdateCursor()
    {
    if (List.IsTop(this))
        Screen::CursorSetPos(HomeRow + CursorRow, HomeCol + CursorCol);
    }

unsigned short Window::WhichRow()
    {
    return CursorRow;
    }

unsigned short Window::WhichCol()
    {
    return CursorCol;
    }

// storage method
void Window::Store(unsigned short row, unsigned short col,
                   unsigned char attr, char sym)
    {
    if ((row < Length) && (col < Width))
        Buffer.Put(row,col,attr,sym);
    }

void Window::Store(unsigned short row, unsigned short col,
                   unsigned char attr, const String & str)
    {
    if ((row >= Length) && (col >= Width))
        return;

    unsigned short i, c = col, r = row;

    if (attr == 0)
        attr = DefaultAttr;

    for (i = 0; i <= str.Length(); ++i)
        {
        Buffer.Put(r,c,attr,str[i]);

        ++c;

        if (c == Width)
            {
            if ((Wrap == WDW_WM_ON) && (r < (Length - 1)))
                {
                c = 0;
                ++r;
                }
            else
                break;
            }
        }
    }

void Window::StoreFormatted(unsigned short row, unsigned short col,
                            unsigned char attr, char * format, ...)
    {
    va_list args;
    char buffer[132];

    va_start(args, format);

    vsprintf(buffer,format,args);
     
    va_end(args);
     
    Store(row, col, attr, buffer);
    }

// display methods
void Window::Display()
    {
    unsigned short row, col;

    for (row = 0; row < Length; ++row)
        {
        for (col = 0; col < Width; ++col)
            {
            if (this == OwnerTable.OwnerOf(HomeRow+row,HomeCol+col))
                Screen::Put(HomeRow+row,HomeCol+col,Buffer.Get(row,col));
            }
        }

    DisplayBorder();

    UpdateCursor();
    }

void Window::Display(unsigned short row)
    {
    if (row >= Length)
        return;

    unsigned short col;

    for (col = 0; col < Width; ++col)
        {
        if (this == OwnerTable.OwnerOf(HomeRow+row,HomeCol+col))
            Screen::Put(HomeRow+row,HomeCol+col,Buffer.Get(row,col));
        }
    }

void Window::Display(unsigned short row, unsigned short col)
    {
    if ((row >= Length) || (col >= Width))
        return;

    if (this == OwnerTable.OwnerOf(HomeRow+row,HomeCol+col))
        Screen::Put(HomeRow+row,HomeCol+col,Buffer.Get(row,col));
    }

void Window::Display(unsigned short row, unsigned short col,
                     unsigned char attr, char sym)
    {
    if (this == OwnerTable.OwnerOf(HomeRow+row,HomeCol+col))
        Screen::Put(HomeRow+row,HomeCol+col,attr,sym);
    }

// clearing methods

void Window::Clear()
    {
    Buffer.Fill(DefaultAttr,' ');
    }

void Window::Clear(unsigned short row, unsigned short col)
    {
    unsigned short c;

    for (c = col; c < Width; ++c)
        Buffer.Put(row,c,DefaultAttr,' ');
    }

// scrolling

void Window::ScrollDown()
    {
    short row, col;

    for (row = Length - 1; row > 0; --row)
        for (col = 0; col < Width; ++col)
            Buffer.Put(row,col,Buffer.Get(row-1,col));

    Clear(0);
    }

void Window::ScrollUp()
    {
    short row, col;

    for (row = 0; row < (Length - 1); ++row)
        for (col = 0; col < Width; ++col)
            Buffer.Put(row,col,Buffer.Get(row+1,col));

    Clear(Length - 1);
    }
