//  WINDOW (TEXT) LIBRARY
//      wdw.h     v1.00   11-Jul-1990
//      Turbo C++ 1.0
//
//      The Window class defines a basic window
//
//      Written by Scott Robert Ladd.

#if !defined(WDW_H)
#define WDW_H

#include "screen.h"
#include "str.h"
#include "wdwbuffe.h"
#include "wdwowner.h"
#include "wdwlist.h"

enum HeadingStyle {WDW_HS_NONE, WDW_HS_LEFT, WDW_HS_CENTER, WDW_HS_RIGHT};

enum WrapMode {WDW_WM_ON, WDW_WM_OFF};

class Window
    {
    public:
        // constructors
        Window(unsigned short hrow,
               unsigned short hcol,
               unsigned short erow,
               unsigned short ecol,
               unsigned char attr,
               BoxType border,
               HeadingStyle style,
               const String & headText,
               unsigned char battr);

        Window(const Window & w);

        // destructor
        ~Window();

        // get version number
        static unsigned short Version();

        // error handler
        static void SetErrorHandler(void (* userHandler)(const String & msg));
        static void Error(const String & msg);

        // wallpaper method
        static void SetWallpaper(unsigned char attr, char sym);

        // change the border characteristics
        void SetHeader(HeadingStyle style, const String & text);
        void SetBorderAttr(unsigned char attr);
        void SetBorderType(BoxType border);

        // move method
        void Move(unsigned short row, unsigned short col);

        // change level of window in the stack
        void Hoist();   // bring to top of stack
        void Drop();    // drop to bottom of stack

        // change / read wrapmode
        WrapMode WrapStatus();

        void SetWrap(WrapMode wm);

        // cursor methods
        void PlaceCursor(unsigned short row, unsigned short col);
        void UpdateCursor();

        unsigned short WhichRow();
        unsigned short WhichCol();

        // storage method
        void Store(unsigned short row, unsigned short col,
                   unsigned char attr, char sym);

        void Store(unsigned short row, unsigned short col,
                   unsigned char attr, const String & str);

        void StoreFormatted(unsigned short row, unsigned short col,
                            unsigned char attr, char * format, ...);

        // display methods
        void Display();
        void Display(unsigned short row);
        void Display(unsigned short row, unsigned short col);

        // clearing methods

        void Clear();
        void Clear(unsigned short row, unsigned short col = 0);

        // scrolling
        void ScrollDown();
        void ScrollUp();

    protected:
        // extent of the window
        unsigned short HomeRow;
        unsigned short HomeCol;
        unsigned short EndRow;
        unsigned short EndCol;
        unsigned short Length;
        unsigned short Width;

        // border type
        BoxType BorderType;

        // wrapping mode
        WrapMode Wrap;

        // heading information
        String       Heading;
        HeadingStyle HeadStyle;

        // cursor information
        unsigned short CursorRow;
        unsigned short CursorCol;

        // attribute data
        unsigned char DefaultAttr;
        unsigned char BorderAttr;

        // window buffer
        WdwBuffer Buffer;

        // error handler pointer
        static void (* ErrorHandler)(const String & msg);

        // flag to indicate intialization
        static short Initialized;

        // wallpaper values
        static unsigned char WallpaperAttr;
        static char WallpaperSymbol;

        // ownership array
        static WdwOwnerTable OwnerTable;

        // list of windows
        static WdwList List;

        // static dimensions of the display
        static unsigned short ScreenRows;
        static unsigned short ScreenCols;

    private:
        // private display method used for border heading
        void Display(unsigned short row, unsigned short col,
                     unsigned char attr, char sym);

        // display just a border
        void DisplayBorder();

        // set screen locations owned by a window
        void SetOwnership();

        // draw wallpaper
        static void DrawWallpaper();

        // reset all window ownership and displays
        static void ResetWindows();
    };

// get version number
inline unsigned short Window::Version()
    {
    return 100;
    }

#endif
