//  ECOSYSTEM SIMULATION PROGRAM
//      sniffer.h    2.00    08-Aug-1990
//      Borland Turbo C++ 1.0
//
//      Sniffer class definition
//
//      Written by Scott Robert Ladd

#if !defined(SNIFFER_H)
#define SNIFFER_H

#include "creature.h"

class Sniffer : public Creature
    {
    public:
        // basic constructor
        Sniffer(int x, int y);

        // copy constructor (used in birth of a new Sniffer)
        Sniffer(const Sniffer & G);

        // destructor
        virtual ~Sniffer();

        // get creature's species
        virtual CreatureSpecies Species()
            {
            return CS_SNIFFER;
            }

        // ask grazer to do something
        virtual MoveResult Move();

        // tell grazer to draw itself
        virtual void Draw();

        // tell grazer to erase itself
        virtual void Erase();

    protected:
        int Sense;        // distance at which food is sensed
        int AgeRep;

        static const int Size;         // size of a sniffer
        static const int Color;        // color of Sniffers
        static const int DiagMoveCost; // energy cost to move diagonally
        static const int OrthMoveCost; // energy cost to move orthagonally
        static const int FoodValue;    // energy obtained from eating food
        static const int MaxSense;     // maximum sense value
        static const int ReproAge;     // age at which a Grazer can reproduce
        static const int RepEnergy;    // energy required for reproduction
    };

#endif
