//  SCREEN LIBRARY
//      scrtest.cpp     v4.00   02-Aug-1990
//      Turbo C++ 1.0
//
//      Test program for Screen class
//
//      Written by Scott Robert Ladd

#include "screen.h"
#include "conio.h"

unsigned short l = 0, w = 0, r = 0, c = 0;

int main()
    {
    Screen::SetMode(SCR_MODE_25x80);

    // Screen::SetAccess(SCR_ACC_BIOS);

    Screen::Dimensions(l,w);

    for (r = 0; r < l; ++r)
        for (c = 0; c < w; ++c)
            Screen::Put(r,c,112,'*');

    while (!kbhit()) ;
    if (!getch()) getch();

    Screen::Clear();

    l = 10;

    for (c = 0; c < 40; c += 5)
        {
        Screen::Put(l,c,7,"This is a test string!");
        ++l;
        }

    while (!kbhit()) ;
    if (!getch()) getch();

    Screen::ScrollUp(0,0,l-1,w-1,112,2);

    while (!kbhit()) ;
    if (!getch()) getch();

    Screen::ScrollDown(0,0,l-1,w-1,112,2);

    while (!kbhit()) ;
    if (!getch()) getch();

    Screen::Clear();

    Screen::DrawBox(2,5,12,30,7,BT_SINGLE);

    while (!kbhit()) ;
    if (!getch()) getch();

    Screen::DrawBox(10,10,15,70,7,BT_DOUBLE);

    while (!kbhit()) ;
    if (!getch()) getch();

    Screen::DrawBox(0,0,24,79,7,BT_SOLID);

    while (!kbhit()) ;
    if (!getch()) getch();

    Screen::Clear();

    Screen::Printf(0,0,112,"%s %g %x","Scott Ladd",3.1415927,3651);

    unsigned short * buf = new unsigned short [30];

    for (c = 0; c < 30; ++c)
        buf[c] = Screen::GetWord(0,c);

    for (c = 0; c < 30; ++c)
        Screen::Put(2,c,buf[c]);

    delete buf;

    while (!kbhit()) ;
    if (!getch()) getch();

    return 0;
    }
