//  SMALL BIT GRID CLASS
//      sbitgrid.h    3.10    04-Aug-1990
//      Turbo C++ 1.0
//
//      A class for a two-dimensional array of bits, with dimensions up to
//      256 by 256.
//
//      Written by Scott Robert Ladd

#if !defined(SBITGRID_HPP)
#define SBITGRID_HPP 1

#include "sbitset.hpp"

class SmallBitGrid : public ShortBitSet
    {
    private:
        unsigned char Width;

    public:
        // constructor
        SmallBitGrid(unsigned char x_dim, unsigned char y_dim)
            : ShortBitSet(x_dim * y_dim)
            {
            Width = x_dim;
            }

        // copy constructor
        SmallBitGrid(const SmallBitGrid & sbg)
            : ShortBitSet(sbg)
            {
            Width = sbg.Width;
            }

        // assignment operator
        void operator = (const SmallBitGrid & sbg)
            {
            Width = sbg.Width;
            ShortBitSet::operator = (sbg);
            }

        // include a bit
        void Include(unsigned char x_pos, unsigned char y_pos)
            {
            ShortBitSet::Include(y_pos * Width + x_pos);
            }

        // exclude a bit
        void Exclude(unsigned char x_pos, unsigned char y_pos)
            {
            ShortBitSet::Exclude(y_pos * Width + x_pos);
            }

        // inclusion method
        int IsSet(unsigned char x_pos, unsigned char y_pos) const
            {
            return ShortBitSet::operator [] (y_pos * Width + x_pos);
            }
    };

#endif
