//  LARGE BIT SET CLASS
//      lbitset     3.10    04-Aug-1990
//      Turbo C++ 1.0
//
//      Defines a set of bits
//
//      Written by Scott Robert Ladd

#if !defined(LBITSET_HPP)
#define LBITSET_HPP 1

#include "stddef.h"
#include "string.h"

class LongBitSet
    {
    protected:
        unsigned long   Length;
        unsigned char * Data;

        LongBitSet()
            {
            Length = 0L;
            Data   = NULL;
            }

    public:
        // constructors
        LongBitSet(unsigned long size);

        LongBitSet(const LongBitSet & bs);

        // destructor
        ~LongBitSet(void);

        // assignment operator
        void operator = (const LongBitSet & bs);

        // Get number of bits in set
        unsigned long Size() const
            {
            return Length;
            }

        // operation methods
        void Include(unsigned long bit)
            {
            if (bit < Length)
                Data[bit / 8UL] |= (unsigned char)(1UL << (bit & 7UL));
            }

        void Exclude(unsigned long bit)
            {
            if (bit < Length)
                Data[bit / 8UL] &= ~(unsigned char)(1UL << (bit & 7UL));
            }

        // turn all bits in set on
        void AllOn()
            {
            memset(Data,'\xFF',(unsigned int)((Length + 7UL) / 8UL));
            }

        // turn all bits in set off
        void AllOff()
            {
            memset(Data,'\x00',(unsigned int)((Length + 7UL) / 8UL));
            }

        // union operators
        LongBitSet operator &  (const LongBitSet & bs);
        LongBitSet operator &= (const LongBitSet & bs);

        // synonyms for union operators
        LongBitSet operator +  (const LongBitSet & bs);
        LongBitSet operator += (const LongBitSet & bs);

        // intersection operators
        LongBitSet operator |  (const LongBitSet & bs);
        LongBitSet operator |= (const LongBitSet & bs);

        // difference operators
        LongBitSet operator -  (const LongBitSet & bs);
        LongBitSet operator -= (const LongBitSet & bs);

        // complement operator
        LongBitSet operator ~ ();

        // comparison operator
        int operator == (const LongBitSet & bs) const;
        int operator != (const LongBitSet & bs) const;

        // value retrieval method
        int operator [] (unsigned long bit) const
            {
            if (bit < Length)
                return (Data[bit / 8UL] & (unsigned char)(1UL << (bit & 7UL)));
            else
                return 0;
            }
    };

#endif
