//  LARGE BIT GRID CLASS
//      lbitgrid.h  3.00    28-May-1990
//      Turbo C++ 1.0
//
//      A class for a two-dimensional array of bits, with dimensions up to
//      65,536 by 65,536 bits.
//
//      Written by Scott Robert Ladd

#if !defined(LBITGRID_H)
#define LBITGRID_H 1

#include "lbitset.h"

class LargeBitGrid : public LongBitSet
    {
    private:
        unsigned int Width;

    public:
        // constructor
        LargeBitGrid(unsigned int x_dim, unsigned int y_dim)
            : LongBitSet(x_dim * y_dim)
            {
            Width = x_dim;
            }

        // copy constructor
        LargeBitGrid(const LargeBitGrid & lbg)
            : LongBitSet(lbg)
            {
            Width = lbg.Width;
            }

        // assignment operator
        void operator = (const LargeBitGrid & lbg)
            {
            Width = lbg.Width;
            LongBitSet::operator = (lbg);
            }

        // include a bit
        void Include(unsigned int x_pos, unsigned int y_pos)
            {
            LongBitSet::Include(y_pos * Width + x_pos);
            }

        // exclude a bit
        void Exclude(unsigned int x_pos, unsigned int y_pos)
            {
            LongBitSet::Exclude(y_pos * Width + x_pos);
            }

        // inclusion method
        int IsSet(unsigned int x_pos, unsigned int y_pos) const
            {
            return LongBitSet::operator [] (y_pos * Width + x_pos);
            }
    };

#endif
