//  ECOSYSTEM SIMULATION PROGRAM
//      ecosys.hpp  2.00    07-Aug-1990
//      Borland Turbo C++ 1.0
//
//      EcoSys class definition
//
//      Written by Scott Robert Ladd

#include "ecosys.h"
#include "creature.h"
#include "sniffer.h"
#include "zipper.h"
#include "randval.h"
#include "conio.h"
#include "time.h"
#include "stdio.h"
#include "stdlib.h"
#include "graphics.h"

// These definitions change how food is distributed
const int EcoSystem::FoodColor     =     2; // green
const int EcoSystem::NewFood       =    10;
const int EcoSystem::InitFood      = 12000;
const int EcoSystem::InitCreatures =    15;

EcoSystem::EcoSystem() : CList()
    {
    int graphdriver   = VGA;
    int graphmode     = VGAHI;
    int graphicerr    = 0;

    // this is the directory in which the BGI drivers are to be found
    char driverpath[] = "D:\\TCPP\\BGI";

    initgraph(&graphdriver,&graphmode,driverpath);

    graphicerr = graphresult();

    if (graphicerr != grOk)
        {
        printf("Error: Borland Graphics initgraph failed\n");
        exit(255);
        }

    // constants which define the size of the grid array
    MaxX = getmaxx() -  1;
    MaxY = getmaxy() - 15; // leave room for the status line

    srand(unsigned(time(NULL)));

    FoodSupply = new LargeBitGrid (MaxX, MaxY);

    Creature::SetRegion(FoodSupply, MaxX, MaxY);

    Sniffer * S;
    Zipper  * Z;
    int i, x, y;

    for (i = 0; i < InitCreatures; ++i)
        {
        x = RandVal(MaxX);
        y = RandVal(MaxY);

        S = new Sniffer(x,y);
        CList.Add(S);

        if (S == NULL)
            {
            printf("Error: Init Sniffers\n");
            exit(255);
            }

        x = RandVal(MaxX);
        y = RandVal(MaxY);

        Z = new Zipper(x,y);
        CList.Add(Z);

        if (Z == NULL)
            {
            printf("Error: Init Zippers\n");
            exit(255);
            }
        }

    for (i = 0; i < InitFood; ++i)
        {
        do  {
            x = RandVal(MaxX);
            y = RandVal(MaxY);
            }
        while (FoodSupply->IsSet(x,y));

        FoodSupply->Include(x,y);

        putpixel(x,y,FoodColor);
        }
    }

void EcoSystem::LifeCycle()
    {
    Creature * C, * newC;
    Sniffer  * newSniffer;
    Zipper   * newZipper;
    unsigned long move;
    char stat_line[20];
    int x, y, i;

    move = 0L;

    while (Creature::Population() > 0)
        {
        if (kbhit())
            {
            char ch;

            if (!getch())
                getch();

            // erase old status line by writing over it
            setcolor(BLACK);
            outtextxy(0,MaxY + 1,"\xDB\xDB\xDB\xDB\xDB\xDB\xDB\xDB\xDB"
                                 "\xDB\xDB\xDB\xDB\xDB\xDB\xDB\xDB\xDB");

            // display information line
            setcolor(WHITE);
            outtextxy(0,MaxY + 1,"Press Q to Quit, other key to continue");

            ch = (char)getch();

            // erase information line by writing over it
            setcolor(BLACK);
            outtextxy(0,MaxY + 1,"\xDB\xDB\xDB\xDB\xDB\xDB\xDB\xDB\xDB\xDB"
                                 "\xDB\xDB\xDB\xDB\xDB\xDB\xDB\xDB\xDB\xDB"
                                 "\xDB\xDB\xDB\xDB\xDB\xDB\xDB\xDB\xDB\xDB"
                                 "\xDB\xDB\xDB\xDB\xDB\xDB\xDB\xDB\xDB\xDB");

            if (!ch)
                ch = (char)getch();

            if ((ch == 'Q') || (ch == 'q'))
                return;
            }

        C = CList.AtBottom();

        while (C != NULL)
            {
            switch (C->Move())
                {
                case MR_DIED:
                    CList.Delete(C);
                    delete C;
                    break;

                case MR_REPRODUCED:
                    // this should be converted to a switch statement
                    // when other creature classes are added
                    switch (C->Species())
                        {
                        case CS_SNIFFER:
                            newSniffer = new Sniffer (*((Sniffer *)(C)));
                            newC = newSniffer;
                            break;

                        case CS_ZIPPER:
                            newZipper = new Zipper (*((Zipper *)(C)));
                            newC = newZipper;
                            break;
                        }

                    if (newC == NULL)
                        {
                        printf("could not give birth to new creature");
                        exit(255);
                        }

                    CList.Add(newC);
                }

            C = CList.NextCreature();
            }

        for (i = 0; i < NewFood; ++i)
            {
            do  {
                x = RandVal(MaxX);
                y = RandVal(MaxY);
                }
            while (FoodSupply->IsSet(x,y));

            FoodSupply->Include(x,y);

            putpixel(x,y,FoodColor);
            }

        ++move;

        sprintf(stat_line,"M: %6ld, C: %3d",move,Creature::Population());

        // erase old status line by writing over it
        setcolor(BLACK);
        outtextxy(0,MaxY + 1,"\xDB\xDB\xDB\xDB\xDB\xDB\xDB\xDB\xDB"
                             "\xDB\xDB\xDB\xDB\xDB\xDB\xDB\xDB\xDB");

        // display new status line
        setcolor(WHITE);
        outtextxy(0,MaxY + 1,stat_line);
        }
    }

EcoSystem::~EcoSystem()
    {
    closegraph();
    }
