//  ECOSYSTEM SIMULATION PROGRAM
//      creature.h    2.00    07-Aug-1990
//      Borland Turbo C++ 1.0
//
//      Creature class definition
//
//      Written by Scott Robert Ladd

#if !defined(CREATURE_H)
#define CREATURE_H

#include "lbitgrid.h"

enum MoveResult      {MR_MOVED, MR_DIED, MR_REPRODUCED};
enum CreatureSpecies {CS_GRAZER, CS_SNIFFER, CS_ZIPPER};

class Creature
    {
    protected:
        int Energy;                 // current energy level
        int Age;                    // current age

        int PosX, PosY;             // position on screen

        static int MaxX;            // maximum X dimension for Grazer
        static int MaxY;            // maximum Y dimension for Grazer

        static int Count;           // current population of creatures

        static LargeBitGrid * FoodSupply; // pointer to food supply for grazers

        static const int MoveTable[8][2]; // class-global table of movements
        static const int NoDirections;    // number of possible movement directions

    public:
        // constructor
        Creature(int e, int x, int y);

        // destructor
        virtual ~Creature();

        // set food supply and area dimensions
        static void SetRegion(LargeBitGrid * food, int xmax, int ymax);

        // return population of creatures
        static int Population()
            {
            return Count;
            }

        // get creature's species
        virtual CreatureSpecies Species() = 0;

        // ask creature to perform an action
        virtual MoveResult Move() = 0;

        // tell creature to draw itself
        virtual void Draw() = 0;

        // tell creature to erase itself
        virtual void Erase() = 0;
    };

#endif
