//  POLYMORPHISM EXAMPLE
//      animals2.cpp     1.00    04-Aug-1990
//      Turbo C++ 1.0
//
//      Polymorphic kennel management program
//
//      Written by Scott Robert Ladd

#include "stdio.h"
#include "stdlib.h"
#include "string.h"

class Animal
    {
    protected:
        char * Name;

    public:
        Animal()
            {
            Name = NULL;
            }

        Animal(char * n)
            {
            Name = strdup(n);
            }

        ~Animal()
            {
            delete Name;
            }

        virtual void WhoAmI()
            {
            printf("generic animal");
            }
    };

class Cat : public Animal
    {
    public:
        Cat() : Animal() { /* empty */ }

        Cat(char * n)
            : Animal(n)
            { /* empty */ }

        virtual void WhoAmI()
            {
            printf("I am a cat named %s\n",Name);
            }
    };

class Dog : public Animal
    {
    public:
        Dog() : Animal() { /* empty */ }

        Dog(char * n)
            : Animal(n)
            { /* empty */ }

        virtual void WhoAmI()
            {
            printf("I am a dog named %s\n",Name);
            }
    };

class Kennel
    {
    private:
        unsigned int MaxAnimals;
        unsigned int NumAnimals;
        Animal ** Residents;

    public:
        Kennel(unsigned int max);

        ~Kennel();

        unsigned int Accept(Animal * d);

        Animal * Release(unsigned int pen);

        void ListAnimals();
    };

Kennel::Kennel(unsigned int max)
    {
    MaxAnimals = max;

    NumAnimals = 0;

    Residents = new Animal * [MaxAnimals];

    for (int i = 0; i < MaxAnimals; ++i)
        Residents[i] = NULL;
    }

Kennel::~Kennel()
    {
    delete Residents;
    }

unsigned int Kennel::Accept(Animal * d)
    {
    if (NumAnimals == MaxAnimals)
        return 0;

    ++NumAnimals;

    int i = 0;

    while (Residents[i] != NULL)
        ++i;

    Residents[i] = d;

    return i + 1;
    }

Animal * Kennel::Release(unsigned int pen)
    {
    if (pen > MaxAnimals)
        return NULL;

    --pen;

    if (Residents[pen] != NULL)
        {
        Animal * temp = Residents[pen];
        Residents[pen] = NULL;
        --NumAnimals;
        return temp;
        }
    else
        return NULL;
    }

void Kennel::ListAnimals()
    {
    if (NumAnimals > 0)
        {
        for (int i = 0; i < MaxAnimals; ++i)
            {
            if (Residents[i] != NULL)
                {
                printf("The animal in pen %d says: ",i + 1);
                Residents[i]->WhoAmI();
                }
            }
        }
    }

Dog d1("Rover");
Dog d2("Spot");
Dog d3("Chip");
Dog d4("Buddy");
Dog d5("Butch");

Cat c1("Tinkerbell");
Cat c2("Inky");
Cat c3("Fluffy");
Cat c4("Princess");
Cat c5("Sylvester");

int main()
    {
    Kennel K(20); // max of ten cats and dogs

    // animals are brought in and taken out
    K.Accept(&d1);

    unsigned int c2pen = K.Accept(&c2);

    K.Accept(&d3);
    K.Accept(&c1);

    unsigned int d4pen = K.Accept(&d4);

    K.Accept(&d5);
    K.Accept(&c5);

    K.Release(c2pen);

    K.Accept(&c4);
    K.Accept(&c3);

    K.Release(d4pen);

    K.Accept(&d2);

    K.ListAnimals();
    }
