//  ECOSYSTEM SIMULATION PROGRAM
//      zipper.cpp    2.00  07-Aug-1990
//      Borland Turbo C++ 1.0
//
//      Zipper class implementation
//
//      Written by Scott Robert Ladd

#include "zipper.h"
#include "randval.h"
#include "stdio.h"
#include "stdlib.h"
#include "graphics.h"

// initialize the static members of Zipper class
const int Zipper::Size         =    1; // three by three
const int Zipper::Color        =   14; // yellow square
const int Zipper::DiagMoveCost =    5;
const int Zipper::OrthMoveCost =    3;
const int Zipper::RepEnergy    = 5000;
const int Zipper::FoodValue    =   60;
const int Zipper::MaxTurnGene  =  100;
const int Zipper::MinTurnGene  =    1;

// basic constructor for a new creature
Zipper::Zipper(int x, int y)
    : Creature(RepEnergy/2,x,y)
    {
    TurnGene  = RandVal(30) + 5;
    Direction = RandVal(NoDirections) - 1;
    MoveCount = 0;

    Draw();
    }

// copy constructor
Zipper::Zipper(const Zipper & Z)
    : Creature(Z.Energy,Z.PosX,Z.PosY)
    {
    TurnGene  = Z.TurnGene;
    MoveCount = 0;

    do  {
        Direction = RandVal(NoDirections) - 1;
        }
    while (Direction == Z.Direction);

    if (RandVal(2) == 1)
        {
        TurnGene -= RandVal(5) + 2;

        if (TurnGene < MinTurnGene)
            TurnGene = MinTurnGene;
        }
    else
        {
        TurnGene += RandVal(5) + 2;

        if (TurnGene > MaxTurnGene)
            TurnGene = MaxTurnGene;
        }

    Draw();
    }

// destructor
Zipper::~Zipper()
    {
    Erase();
    }

// ask Zipper to do something
MoveResult Zipper::Move()
    {
    if (Energy >= RepEnergy)
        {
        Energy /= 2;

        return MR_REPRODUCED;
        }

    if (MoveCount == TurnGene)
        {
        MoveCount = 0;

        if (RandVal(2) == 1)
            {
            if (Direction > 0)
                --Direction;
            else
                Direction = 7;
            }
        else
            {
            if (Direction < 7)
                ++Direction;
            else
                Direction = 0;
            }
        }
    else
        {
        ++MoveCount;
        }

    if ((Direction == 0) || (Direction == 2)
    ||  (Direction == 5) || (Direction == 7))
        Energy -= DiagMoveCost;
    else
        Energy -= OrthMoveCost;

    // did it die?
    if (Energy <= 0)
        return MR_DIED;

    int newx = PosX + MoveTable[Direction][0] * (1 + 2 * Size);
    int newy = PosY + MoveTable[Direction][1] * (1 + 2 * Size);

    Erase();

    PosX = newx;
    PosY = newy;

    if (PosX < Size) PosX = MaxX;
    if (PosX > MaxX) PosX = Size;
    if (PosY < Size) PosY = MaxY;
    if (PosY > MaxY) PosY = Size;

    for (int x = PosX - Size; x <= PosX + Size; ++x)
        {
        for (int y = PosY - Size; y <= PosY + Size; ++y)
            {
            if (FoodSupply->IsSet(x,y))
                {
                FoodSupply->Exclude(x,y);
                Energy += FoodValue;
                }
            }
        }

    Draw();

    return MR_MOVED;
    }

// tell Zipper to draw itself
void Zipper::Draw()
    {
    for (int x = PosX - Size; x <= PosX + Size; ++x)
        {
        for (int y = PosY - Size; y <= PosY + Size; ++y)
            putpixel(x,y,Color);
        }
    }

// tell Zipper to erase itself
void Zipper::Erase()
    {
    for (int x = PosX - Size; x <= PosX + Size; ++x)
        {
        for (int y = PosY - Size; y <= PosY + Size; ++y)
            putpixel(x,y,0); // black
        }
    }
