//  WINDOW (TEXT) LIBRARY
//      wdwowner.h    v1.00   11-Jul-1990
//      Turbo C++ 1.0
//
//      Defines a window border
//
//      Written by Scott Robert Ladd.

#if !defined(WDWOWNER_H)
#define WDWOWNER_H

class Window;

class WdwOwnerTable
    {
    private:
        Window * * OwnerArray;

        unsigned short RowSize;
        unsigned short ColSize;

    public:
        WdwOwnerTable();

        ~WdwOwnerTable();

        void SetSize(unsigned short rows, unsigned short cols);

        void Clear();

        Window * OwnerOf(unsigned short row, unsigned short col);

        void SetOwner(unsigned short row, unsigned short col, Window * w);
    };

inline Window * WdwOwnerTable::OwnerOf(unsigned short row, unsigned short col)
    {
    return OwnerArray[row * ColSize + col];
    }

inline void WdwOwnerTable::SetOwner(unsigned short row, unsigned short col,
                                    Window * w)
    {
    OwnerArray[row * ColSize + col] = w;
    }

#endif
