//  WINDOW (TEXT) LIBRARY
//      wdwowner.cpp    v1.00   11-Jul-1990
//      Turbo C++ 1.0
//
//      Defines a window border
//
//      Written by Scott Robert Ladd.

#include "stddef.h"
#include "wdwowner.h"

WdwOwnerTable::WdwOwnerTable()
    {
    RowSize = 0;
    ColSize = 0;

    OwnerArray = NULL;
    }

void WdwOwnerTable::SetSize(unsigned short rows, unsigned short cols)
    {
    RowSize = rows;
    ColSize = cols;

    if (OwnerArray != NULL)
        delete OwnerArray;

    OwnerArray = new Window * [rows * cols];

    Clear();
    }

WdwOwnerTable::~WdwOwnerTable()
    {
    delete OwnerArray;
    }

void WdwOwnerTable::Clear()
    {
    unsigned short row, col;

    for (row = 0; row < RowSize; ++row)
        for (col = 0; col < ColSize; ++col)
            OwnerArray[row * ColSize + col] = NULL;
    }
