//  WINDOW (TEXT) LIBRARY
//      wdwlist.h     v1.00   11-Jul-1990
//      Turbo C++ 1.0
//
//      This is a list class used by the Window class
//
//      Written by Scott Robert Ladd.

#if !defined(WDWLIST_H)
#define WDWLIST_H

class Window;

struct WdwListNode
    {
    WdwListNode * Prev;
    WdwListNode * Next;

    Window * WdwPtr;
    };

class WdwList
    {
    public:
        // constructor
        WdwList();

        // destructor
        ~WdwList();

        // add node to tope of list
        void Add(Window * w);

        // delete node from list
        void Delete(Window * w);

        // move node to top of list
        void Hoist(Window * w);

        // move node to bottom of list
        void Drop(Window * w);

        // check for top window
        short IsTop(Window * w);

        // goto the bottom window in list
        Window * AtBottom();

        // get next window in list
        Window * NextWindow();

    private:
        WdwListNode * Bottom;
        WdwListNode * Top;
        WdwListNode * Current;
    };

#endif
