//  WINDOW (TEXT) LIBRARY
//      wdwlist.cpp     v1.00   11-Jul-1990
//      Turbo C++ 1.0
//
//      This is a list class used by the Window class
//
//      Written by Scott Robert Ladd.

#include "stddef.h"
#include "wdwlist.h"
#include "wdw.h"

// constructor
WdwList::WdwList()
    {
    Bottom  = NULL;
    Top     = NULL;
    Current = NULL;
    }

// destructor
WdwList::~WdwList()
    {
    WdwListNode * nextNode;

    Current = Bottom;

    while (Current != NULL)
        {
        nextNode = Current->Next;
        delete Current;
        Current = nextNode;
        }
    }

// add node to tope of list
void WdwList::Add(Window * w)
    {
    if (w == NULL)
        return;

    if (Top == NULL)
        {
        Top = new WdwListNode;

        if (Top == NULL)
            Window::Error("unable to allocate Top list item");

        Top->Prev = NULL;
        Top->Next = NULL;

        Top->WdwPtr = w;

        Bottom = Top;
        }
    else
        {
        Top->Next = new WdwListNode;

        if (Top->Next == NULL)
            Window::Error("unable to allocate new list item");

        Top->Next->Next = NULL;
        Top->Next->Prev = Top;
        Top = Top->Next;

        Top->WdwPtr = w;
        }
    }

// delete node from list
void WdwList::Delete(Window * w)
    {
    if (w == NULL)
        return;

    Current = Bottom;

    while ((Current != NULL) && (Current->WdwPtr != w))
        Current = Current->Next;

    if (Current->WdwPtr == w)
        {
        if (Current->Prev == NULL)
            Bottom = Current->Next;
        else
            Current->Prev->Next = Current->Next;

        if (Current->Next == NULL)
            Top = Current->Prev;
        else
            Current->Next->Prev = Current->Prev;

        delete Current;
        }
    }

// move node to top of list
void WdwList::Hoist(Window * w)
    {
    if (w == NULL)
        return;

    Delete(w);
    Add(w);
    }

// move node to bottom of list
void WdwList::Drop(Window * w)
    {
    if (w == NULL)
        return;

    Delete(w);

    Bottom->Prev = new WdwListNode;

    if (Bottom->Prev == NULL)
        Window::Error("unable to allocate new list item");

    Bottom->Prev->Prev = NULL;
    Bottom->Prev->Next = Bottom;

    Bottom->Prev->WdwPtr = w;

    Bottom = Bottom->Prev;
    }

// check for top window
short WdwList::IsTop(Window * w)
    {
    if (Top != NULL)
        return (w == Top->WdwPtr);
    else
        return 0;
    }

// goto the bottom window in list
Window * WdwList::AtBottom()
    {
    Current = Bottom;

    if (Current == NULL)
        return NULL;
    else
        return Current->WdwPtr;
    }

// get next window in list
Window * WdwList::NextWindow()
    {
    if (Current == NULL)
        return NULL;
    else
        {
        Current = Current->Next;

        if (Current == NULL)
            return NULL;
        else
            return Current->WdwPtr;
        }
    }
