//  WINDOW (TEXT) LIBRARY
//      wdwbuffer.h     v1.00   11-Jul-1990
//      Turbo C++ 1.0
//
//      Class definition for a window buffer
//
//      Written by Scott Robert Ladd.

#if !defined(WDWBUFFE_H)
#define WDWBUFFE_H

#include "wdwword.h"

class WdwBuffer
    {
    public:
        WdwBuffer();

        WdwBuffer(const WdwBuffer & wb);

        ~WdwBuffer();

        void SetSize(unsigned short rows, unsigned short cols);

        void Fill(unsigned char attr, char sym);

        void Put(unsigned short row, unsigned short col,
                 unsigned char attr, char sym);

        void Put(unsigned short row, unsigned short col,
                 unsigned short word);

        void Get(unsigned short row, unsigned short col,
                 unsigned char & attr, char & sym);

        unsigned short Get(unsigned short row, unsigned short col);

    protected:
        // actual buffer
        WdwWord * Buffer;

        // dimensions
        unsigned short RowSize;
        unsigned short ColSize;
    };

inline void WdwBuffer::Put(unsigned short row, unsigned short col,
                           unsigned char attr, char sym)
    {
    if (Buffer == NULL)
        return;

    Buffer[row * ColSize + col].Put(attr,sym);
    }

inline void WdwBuffer::Put(unsigned short row, unsigned short col,
                           unsigned short word)
    {
    if (Buffer == NULL)
        return;

    Buffer[row * ColSize + col].Put(word);
    }

inline void WdwBuffer::Get(unsigned short row, unsigned short col,
                           unsigned char & attr, char & sym)
    {
    if (Buffer == NULL)
        return;

    Buffer[row * ColSize + col].Get(attr,sym);
    }

inline unsigned short WdwBuffer::Get(unsigned short row, unsigned short col)
    {
    if (Buffer == NULL)
        return 0U;

    return Buffer[row * ColSize + col].Get();
    }

#endif
