//  WINDOW (TEXT) LIBRARY
//      wdwborde.cpp      v1.00   11-Jul-1990
//      Turbo C++ 1.0
//
//      window border methods
//
//      Written by Scott Robert Ladd.

#include "wdw.h"

void Window::SetHeader(HeadingStyle style, const String & text)
    {
    HeadStyle = style;
    Heading   = text;

    DisplayBorder();
    }

void Window::SetBorderAttr(unsigned char attr)
    {
    BorderAttr = attr;

    DisplayBorder();
    }

void Window::SetBorderType(BoxType border)
    {
    BorderType = border;

    ResetWindows();
    }

// draw border
void Window::DisplayBorder()
    {
    unsigned short row, col, start;

    switch (BorderType)
        {
        case BT_SINGLE :
            Display(    -1,   -1,BorderAttr,'\xDA');
            Display(Length,   -1,BorderAttr,'\xC0');
            Display(Length,Width,BorderAttr,'\xD9');
            Display(    -1,Width,BorderAttr,'\xBF');

            for (col = 0; col < Width; ++col)
                {
                Display(    -1,col,BorderAttr,'\xC4');
                Display(Length,col,BorderAttr,'\xC4');
                }

            for (row = 0; row < Length; ++row)
                {
                Display(row,   -1,BorderAttr,'\xB3');
                Display(row,Width,BorderAttr,'\xB3');
                }

            break;

        case BT_DOUBLE :
            Display(    -1,   -1,BorderAttr,'\xC9');
            Display(Length,   -1,BorderAttr,'\xC8');
            Display(Length,Width,BorderAttr,'\xBC');
            Display(    -1,Width,BorderAttr,'\xBB');

            for (col = 0; col < Width; ++col)
                {
                Display(    -1,col,BorderAttr,'\xCD');
                Display(Length,col,BorderAttr,'\xCD');
                }

            for (row = 0; row < Length; ++row)
                {
                Display(row,   -1,BorderAttr,'\xBA');
                Display(row,Width,BorderAttr,'\xBA');
                }
        }

    if (Heading.Length() > Width)
        return;

    switch (HeadStyle)
        {
        case WDW_HS_LEFT:
            for (col = 0; (col < Heading.Length()) && (col < Width); ++col)
                Display(-1,col,BorderAttr,Heading[col]);

            break;

        case WDW_HS_CENTER:
            start = (Width - Heading.Length()) / 2;

            for (col = 0; (col < Heading.Length()) && (col < Length); ++col)
                Display(-1,start + col,BorderAttr,Heading[col]);

            break;

        case WDW_HS_RIGHT:
            start = Width - Heading.Length();

            for (col = 0; col < Heading.Length(); ++col)
                Display(-1,start + col,BorderAttr,Heading[col]);

            break;
        }
    }
