//  SCREEN CLASS
//      scrnset.cpp   v4.00     02-Aug-1990
//      Turbo C++ 1.0
//
//      SetMode method
//
//      Written by Scott Robert Ladd

#include "screen.h"

// set screen mode
short Screen::SetMode(ScrMode mode)
    {
    // don't change to the current mode

    if (VideoMode == mode)
        return 1;

    // if we don't know the type of screen we have, don't change mode

    if (OriginalMode == SCR_MODE_UNKNOWN)
        return 0;

    // make sure the mode requested is valid

    if ((mode < SCR_MODE_25x40) || (mode > SCR_MODE_50x80))
        return 0;

    // set modes

    switch (mode)
        {
        case SCR_MODE_25x40:
            if ((VideoType == SCR_TYPE_MDA) || (VideoType == SCR_TYPE_HGC))
                return 0;
            else
                {
                _AX = 0x0001;
                geninterrupt(0x10);

                Length = 25;
                Width  = 40;
                }

            break;

        case SCR_MODE_25x80:
            if ((VideoType == SCR_TYPE_MDA) || (VideoType == SCR_TYPE_HGC))
                {
                _AX = 0x0007;
                geninterrupt(0x10);
                }
            else // color
                {
                _AX = 0x0003;
                geninterrupt(0x10);

                switch (VideoType)
                    {
                    case SCR_TYPE_CGA:
                        _AX = 0x1112;
                        geninterrupt(0x10);
                        break;

                    case SCR_TYPE_EGA:
                        _AX = 0x1111;
                        geninterrupt(0x10);
                        break;

                    case SCR_TYPE_VGA:
                        _AX = 0x1114;
                        geninterrupt(0x10);
                        break;

                    default:
                        return 0;
                    }
                }


            Length = 25;
            Width  = 80;

            break;

        case SCR_MODE_30x80:
            if (VideoType == SCR_TYPE_VGA)
                {
                _AX = 0x0003;
                geninterrupt(0x10);

                _AX = 0x1111;
                _BL = 0;
                geninterrupt(0x10);

                Length = 30;
                Width  = 80;
                }
            else
                return 0;

            break;

        case SCR_MODE_43x80:
        case SCR_MODE_50x80:
            if ((VideoType >= SCR_TYPE_EGA) || (VideoType <= SCR_TYPE_VGA))
                {
                _AX = 0x0003;
                geninterrupt(0x10);

                _AX = 0x1112;
                _BL = 0;
                geninterrupt(0x10);

                if (VideoType == SCR_TYPE_EGA)
                    Length = 43;
                else
                    Length = 50;

                Width = 80;
                }
            else
                return 0;

            break;

        default:
            return 0;
        }

    VideoMode = mode;

    Clear();

    return 1;
    }
