//  LONG BIT SET CLASS
//      bstest.cpp  v1.00   04-Aug-1990
//      Turbo C++ 1.0
//
//      Test program
//
//      Written by Scott Robert Ladd

#include "lbitset.h"
#include "iostream.h"

void ShowLongBitSet(LongBitSet & bs);

int main()
    {
    unsigned long i;

    LongBitSet bs1(76);
    LongBitSet bs2(13);
    LongBitSet bs3(8);

    for (i = 0; i < bs1.Size(); ++i)
        {
        if (i % 2)
            bs1.Include(i);
        else
            bs1.Exclude(i);
        }

    ShowLongBitSet(bs1);

    bs3 = bs1;

    ShowLongBitSet(bs3);

    for (i = 0; i < bs2.Size(); ++i)
        {
        if (i % 2)
            bs2.Exclude(i);
        else
            bs2.Include(i);
        }

    for (i = 4; i < bs3.Size(); ++ i)
        {
        bs2.Exclude(i);
        }

    ShowLongBitSet(bs2);

    bs3 = bs2 + bs1;
    ShowLongBitSet(bs3);

    bs3 = ~bs2;
    ShowLongBitSet(bs3);

    bs2 = bs1 | bs3;
    ShowLongBitSet(bs2);

    bs2 -= bs3;
    ShowLongBitSet(bs2);

    bs2 = bs1 - bs3;
    ShowLongBitSet(bs2);

    bs3 += bs1;
    ShowLongBitSet(bs3);

    bs3.AllOn();
    ShowLongBitSet(bs3);

    bs3.AllOff();
    ShowLongBitSet(bs3);

    bs3 = bs2;

    if (bs3 == bs1)
        cout << "bs3 == bs1\n";

    if (bs3 == bs2)
        cout << "bs3 == bs2\n";

    if (bs3 != bs1)
        cout << "bs3 != bs1\n";

    if (bs3 != bs2)
        cout << "bs3 != bs2\n";
    }

void ShowLongBitSet(LongBitSet & bs)
    {
    for (long i = 0; i < bs.Size(); ++i)
        if (bs[i])
            cout << '1';
        else
            cout << '0';

    cout << '\n';
    }
