//  ECOSYSTEM SIMULATION PROGRAM
//      ecosys.h  2.00    08-Aug-1990
//      Borland Turbo C++ 1.0
//
//      EcoSys class definition
//
//      Written by Scott Robert Ladd

#if !defined(ECOSYS_H)
#define ECOSYS_H

#include "lbitgrid.h"
#include "crealist.h"

class EcoSystem
    {
    public:
        EcoSystem();

        ~EcoSystem();

        void LifeCycle();

    protected:
        // constants affecting the set-up of the ecosystem
        static const int FoodColor;     // color of food particles
        static const int NewFood;       // food created every move
        static const int InitFood;      // initial amount of food
        static const int InitCreatures; // initial number of creatures

        // the size of the screen area and grid array
        int MaxX;
        int MaxY;

        // bit matrix for food particles
        LargeBitGrid * FoodSupply;

        // list of creatures
        CreatureList CList;
    };

#endif
