//  GLOBAL DYNAMIC MEMORY HANDLER TEMPLATE
//      dynamic     1.00    04-Aug-1990
//      Turbo C++ 1.0
//
//      Implements a template for replacing C++'s default memory
//      allocation operators
//
//      Written by Scott Robert Ladd

#define DYNAMIC_CPP

#include "dynamic.h"
#include "stdlib.h"

void DefNewHandler();

void (* _new_handler)() = DefNewHandler;

void DefNewHandler()
    {
    // does nothing by default!
    }

void * operator new (unsigned int size)
    {
    void * temp = malloc(size);

    if (temp == NULL)
        _new_handler();

    return temp;
    }

void operator delete (void * ptr)
    {
    free(ptr);
    }

void * _vec_new(
    void *       aptr,
    unsigned int num,
    size_t       size,
    void *       (* ctor)(void *))
    {
    aptr = malloc(num * size);

    if ((ctor != NULL) && (aptr != NULL))
        {
        for (unsigned int n = 0; n < num; ++n)
            ctor((char *)aptr + n * size);
        }

    return aptr;
    }

void _vec_delete(
    void *       aptr,
    unsigned int num,
    size_t       size,
    int          (*dtor)(int, void *),
    int          freeup)
    {
    if (aptr == NULL)
        return;

    if (dtor != NULL)
        {
        for (unsigned int n = 0; n < num; ++n)
            dtor(2,(char *)aptr + n * size);
        }

    if (freeup)
        free(aptr);
    }
