//  ECOSYSTEM SIMULATION PROGRAM
//      crealist.h     v2.00   08-Aug-1990
//      Turbo C++ 1.0
//
//      A list of Creature pointers
//
//      Written by Scott Robert Ladd

#if !defined(CREALIST_H)
#define CREALIST_H

class Creature;

struct CreatureListNode
    {
    CreatureListNode * Prev;
    CreatureListNode * Next;

    Creature * CreaturePtr;
    };

class CreatureList
    {
    public:
        // constructor
        CreatureList();

        // destructor
        ~CreatureList();

        // add node to tope of list
        void Add(Creature * w);

        // delete node from list
        void Delete(Creature * w);

        // goto the bottom Creature in list
        Creature * AtBottom();

        // get next Creature in list
        Creature * NextCreature();

    private:
        CreatureListNode * Bottom;
        CreatureListNode * Top;
        CreatureListNode * Current;
    };

#endif
