//  ECOSYSTEM SIMULATION PROGRAM
//      crealist.cpp     v2.00   08-Aug-1990
//      Turbo C++ 1.0
//
//      A list of Creature pointers
//
//      Written by Scott Robert Ladd

#include "crealist.h"
#include "creature.h"
#include "stddef.h"
#include "stdlib.h"
#include "stdio.h"

// constructor
CreatureList::CreatureList()
    {
    Bottom  = NULL;
    Top     = NULL;
    Current = NULL;
    }

// destructor
CreatureList::~CreatureList()
    {
    CreatureListNode * nextNode;

    Current = Bottom;

    while (Current != NULL)
        {
        nextNode = Current->Next;
        delete Current;
        Current = nextNode;
        }
    }

// add node to tope of list
void CreatureList::Add(Creature * w)
    {
    if (w == NULL)
        return;

    if (Top == NULL)
        {
        Top = new CreatureListNode;

        if (Top == NULL)
            {
            printf("unable to allocate Top list item");
            exit(255);
            }

        Top->Prev = NULL;
        Top->Next = NULL;

        Top->CreaturePtr = w;

        Bottom = Top;
        }
    else
        {
        Top->Next = new CreatureListNode;

        if (Top->Next == NULL)
            {
            printf("unable to allocate new list item");
            exit(255);
            }

        Top->Next->Next = NULL;
        Top->Next->Prev = Top;
        Top = Top->Next;

        Top->CreaturePtr = w;
        }
    }

// delete node from list
void CreatureList::Delete(Creature * w)
    {
    CreatureListNode * Temp;

    if (w == NULL)
        return;

    Temp = Bottom;

    while ((Temp != NULL) && (Temp->CreaturePtr != w))
        Temp = Temp->Next;

    if (Temp->CreaturePtr == w)
        {
        if (Temp == Current)
            if (Temp == Bottom)
                Current = Current->Next;
            else
                Current = Current->Prev;

        if (Temp->Prev == NULL)
            Bottom = Temp->Next;
        else
            Temp->Prev->Next = Temp->Next;

        if (Temp->Next == NULL)
            Top = Temp->Prev;
        else
            Temp->Next->Prev = Temp->Prev;

        delete Temp;
        }
    }

// goto the bottom Creature in list
Creature * CreatureList::AtBottom()
    {
    Current = Bottom;

    if (Current == NULL)
        return NULL;
    else
        return Current->CreaturePtr;
    }

// get next Creature in list
Creature * CreatureList::NextCreature()
    {
    if (Current == NULL)
        return NULL;
    else
        {
        Current = Current->Next;

        if (Current == NULL)
            return NULL;
        else
            return Current->CreaturePtr;
        }
    }
