//  WINDOW (TEXT) LIBRARY
//      wdwctdt.cpp     v1.00   11-Jul-1990
//      Turbo C++ 1.0
//
//      Definitions of the constructors and the destructor for the Window class.
//      Also, static data member intializations.
//
//      Written by Scott Robert Ladd.

#include "wdw.h"

// ownership array
WdwOwnerTable Window::OwnerTable;

// list of windows
WdwList Window::List;

// initialization flag
short Window::Initialized = 0; // false!

unsigned short Window::ScreenRows = 0;
unsigned short Window::ScreenCols = 0;

unsigned char Window::WallpaperAttr = SCR_F_WHITE;
char Window::WallpaperSymbol        = ' ';

// constructors
Window::Window(unsigned short hrow,
               unsigned short hcol,
               unsigned short erow,
               unsigned short ecol,
               unsigned char attr,
               BoxType border,
               HeadingStyle style,
               const String & headText,
               unsigned char battr)
    : Buffer(), Heading(headText)
    {
    if (!Initialized)
        {
        Initialized = 1; // true

        Screen::Dimensions(ScreenRows,ScreenCols);

        DrawWallpaper();

        OwnerTable.SetSize(ScreenRows,ScreenCols);
        }

    if ((erow <= hrow) || (ecol <= hcol))
        Error("end position < home position");

    if ((hrow > ScreenRows) || (hcol > ScreenCols)
    ||  (erow > ScreenRows) || (ecol > ScreenCols))
        Error("window beyond edge of screen");

    if (border != BT_NONE)
        {
        if ((hrow == 0) || (hrow == ScreenRows)
        ||  (erow == 0) || (erow == ScreenRows)
        ||  (hcol == 0) || (hcol == ScreenCols)
        ||  (ecol == 0) || (ecol == ScreenCols))
            Error("no space for border!");
        }

    Width  = ecol - hcol + 1;
    Length = erow - hrow + 1;

    HomeCol = hcol;
    HomeRow = hrow;
    EndCol  = ecol;
    EndRow  = erow;

    CursorCol = 0;
    CursorRow = 0;

    Wrap = WDW_WM_OFF;

    DefaultAttr = attr;

    BorderType = border;
    HeadStyle  = style;
    BorderAttr = battr;

    Buffer.SetSize(Length,Width);
    Buffer.Fill(DefaultAttr,' ');

    List.Add(this);

    SetOwnership();

    Display();
    }

Window::Window(const Window & w)
    : Buffer(w.Buffer), Heading(w.Heading)
    {
    Width   = w.Width;
    Length  = w.Length;

    HomeCol = w.HomeCol;
    HomeRow = w.HomeRow;
    EndCol  = w.EndCol;
    EndRow  = w.EndRow;

    DefaultAttr = w.DefaultAttr;

    BorderType = w.BorderType;
    HeadStyle  = w.HeadStyle;
    BorderAttr = w.BorderAttr;
    Heading    = w.Heading;

    List.Add(this);

    SetOwnership();

    Display();
    }

// destructor
Window::~Window()
    {
    List.Delete(this);

    ResetWindows();
    }
