//  DYNAMIC STRING CLASS
//      strtst.cpp  4.00    03-Aug-1990
//      Turbo C++ 1.0
//
//      Test program
//
//      Written by Scott Robert Ladd

#include "str.h"
#include "stdio.h"

void print_string(String & S);

String s1;
String s2("This is the second string!");

int main()
    {
    int ver = String::Version();

    printf("Testing class String version %i\n",ver);
    printf("-----------------------------------\n\n");

    String ls;
    String ls2("Another local string");
    StrCompVal v;

    unsigned int pos, i;
    char ch;

    s1 = s2;

    if (s1 == s2)
        printf("s1 equals s2!\n");
    else
        printf("\as1 is not equal to s2!\n");

    ls = "This is the local string";
    print_string(s1);
    print_string(s2);
    print_string(ls);
    print_string(ls2);
    printf("\n");

    s1 = s2 + ls + '@';
    print_string(s1);

    v = s1.Compare(s2);

    switch (v)
        {
        case SC_LESS :
            printf("s1 < s2\n");
            break;
        case SC_EQUAL :
            printf("s1 = s2\n");
            break;
        case SC_GREATER :
            printf("s1 > s2\n");
        }

    s1 = "String one has a value";
    print_string(s1);

    s1 = s1 + "****";
    s1 += '?';
    print_string(s1);

    s2 += "*****";
    print_string(s2);
    print_string(ls);

    s2 += ls;
    print_string(s2);

    printf("\n");

    if (s2.Find("Burfulgunk",pos))
       printf("first search = %d\n",pos);

    if (s2.Find("*****",pos))
       printf("second search = %d\n",pos);

    if (s2.Find(ls,pos))
        printf("third search = %d\n",pos);

    if (s2.Find(s1,pos))
        printf("fourth search = %d\n",pos);

    ls2 = "&&";

    s1.Insert(10,'*');
    s1.Insert(15,ls2);
    print_string(s1);

    /*
    s1.Insert(s1.Length(),'%');
    s1.Insert(s1.Length(),'%');
    s1.Insert(s1.Length(),'%');
    s1.Insert(s1.Length(),'%');
    print_string(s1);
    */

    for (i = 0; 0 != (ch = s1[i]); ++i)
         putchar(ch);

    putchar('\n');

    s1.Insert(2,"<><><><><>");
    print_string(s1);

    s1.Delete(2,10);
    print_string(s1);

    s2 = s1.ToUpper();
    print_string(s2);

    s2 = s1.ToLower();
    print_string(s2);

    s1 = "";
    print_string(s1);

    s1 = s2.SubStr(2,10);
    print_string(s1);

    return 0;
    }

void print_string(String & S)
    {
    const char * buffer;

    buffer = (const char *)S;

    if (buffer != NULL)
        printf("%s ",buffer);

    printf("Len = %u Siz = %u\n",S.Length(),S.Size());
    }
