//  POLYMORPHIC SORTING
//      sort.h      1.00    04-Aug-1990
//
//      Sort abstract class definition
//
//      Written by Scott Robert Ladd

#if !defined(SORT_H)
#define SORT_H

class SortArray
    {
    protected:
        void * Array;
        int    Size;

        int (* Compare)(void *, void *);

        void * ItemPtr(int item)
            {
            return (void *)((char *)Array + (Size * (item - 1)));
            }

    public:
        virtual void Sort(void * arrayPtr, int arrayLen, int itemSize,
                          int (* CompareFunc)(void * item1, void * item2))
            {
            Array = arrayPtr;
            Size  = itemSize;

            Compare = CompareFunc;
            }
    };

#endif
