//  ECOSYSTEM SIMULATION PROGRAM
//      sniffer.cpp    2.00    08-Aug-1990
//      Turbo C++ 1.0
//
//      Sniffer class implementation
//
//      Written by Scott Robert Ladd

// include class definition
#include "sniffer.h"
#include "randval.h"
#include "stdio.h"
#include "stdlib.h"
#include "graphics.h"

// initialize the static members of Sniffer class
const int Sniffer::Size         =    1;
const int Sniffer::Color        =    9; // blue
const int Sniffer::DiagMoveCost =   10;
const int Sniffer::OrthMoveCost =    6;
const int Sniffer::FoodValue    =   25;
const int Sniffer::ReproAge     =  200;
const int Sniffer::RepEnergy    = 4000;
const int Sniffer::MaxSense     =    4;

// basic constructor for a new creature
Sniffer::Sniffer(int x, int y)
    : Creature(RepEnergy/2,x,y)
    {
    Sense = 1;

    AgeRep = 0;

    Draw();
    }

// copy constructor
Sniffer::Sniffer(const Sniffer & S)
    : Creature(S.Energy,S.PosX,S.PosY)
    {
    Sense = S.Sense;

    AgeRep = 0;

    if (1 == RandVal(2))
        {
        if (Sense < MaxSense)
            ++Sense;
        }
    else
        {
        if (Sense > 1)
            --Sense;
        }

    Draw();
    }

// destructor
Sniffer::~Sniffer()
    {
    Erase();
    }

// ask Sniffer to do something
MoveResult Sniffer::Move()
    {
    ++AgeRep;

    if ((AgeRep >= ReproAge) && (Energy >= RepEnergy))
        {
        AgeRep = 0;

        Energy /= 2;

        return MR_REPRODUCED;
        }

    int i, j, x, y, ix, iy, move_value;
    int hi_value = -1;
    int move = 0;

    for (i = 0; i < 8; ++i)
        {
        move_value = 0;

        x = PosX;
        y = PosY;

        for (j = 0; j < Sense; ++j)
            {
            x += MoveTable[i][0] * (1 + 2 * Size);
            y += MoveTable[i][1] * (1 + 2 * Size);

            if (x < Size) x = MaxX;
            if (x > MaxX) x = Size;
            if (y < Size) y = MaxY;
            if (y > MaxY) y = Size;

            for (ix = x - Size; ix <= x + Size; ++ix)
                {
                for (iy = y - Size; iy <= y + Size; ++iy)
                    {
                    if (FoodSupply->IsSet(ix,iy))
                        ++move_value;
                    }
                }
            }

        if (move_value > hi_value)
            {
            hi_value = move_value;
            move = i;
            }
        else
            if (move_value == hi_value)
                {
                if (RandVal(i + 1) == 1)
                    move = i;
                }
        }

    if ((move == 0) || (move == 2) || (move == 5) || (move == 7))
        Energy -= DiagMoveCost; // moving at angles costs more!
    else
        Energy -= OrthMoveCost;

    // did it die?
    if (Energy <= 0)
        return MR_DIED;

    int newx = PosX + MoveTable[move][0] * (1 + 2 * Size);
    int newy = PosY + MoveTable[move][1] * (1 + 2 * Size);

    Erase();

    PosX = newx;
    PosY = newy;

    if (PosX < Size) PosX = MaxX;
    if (PosX > MaxX) PosX = Size;
    if (PosY < Size) PosY = MaxY;
    if (PosY > MaxY) PosY = Size;

    for (x = PosX - Size; x <= PosX + Size; ++x)
        {
        for (y = PosY - Size; y <= PosY + Size; ++y)
            {
            if (FoodSupply->IsSet(x,y))
                {
                Energy += FoodValue;
                FoodSupply->Exclude(x,y);
                }
            }
        }

    Draw();

    return MR_MOVED;
    }

// tell Sniffer to draw itself
void Sniffer::Draw()
    {
    for (int x = PosX - Size; x <= PosX + Size; ++x)
        {
        for (int y = PosY - Size; y <= PosY + Size; ++y)
            putpixel(x,y,Color);
        }
    }

// tell Sniffer to erase itself
void Sniffer::Erase()
    {
    for (int x = PosX - Size; x <= PosX + Size; ++x)
        {
        for (int y = PosY - Size; y <= PosY + Size; ++y)
            putpixel(x,y,0); // black
        }
    }
