//  SCREEN CLASS
//      scrnbox.cpp     v4.00   02-Aug-1990
//      Turbo C++ 1.0
//
//      DrawBox method
//
//      Written by Scott Robert Ladd

#include "screen.h"

// box display methods
void Screen::DrawBox(unsigned short toprow, unsigned short leftCol,
                     unsigned short btmrow, unsigned short rightCol,
                     unsigned char attr, BoxType typeBox)
    {
    if ((typeBox == BT_NONE) || (leftCol >= rightCol) || (toprow >= btmrow))
        return;

    char v, h;

    switch (typeBox)
        {
        case BT_SINGLE:
            v = '\xB3';
            h = '\xC4';
            Put(toprow, leftCol,  attr, '\xDA');
            Put(toprow, rightCol, attr, '\xBF');
            Put(btmrow, leftCol,  attr, '\xC0');
            Put(btmrow, rightCol, attr, '\xD9');
            break;
        case BT_DOUBLE:
            v = '\xBA';
            h = '\xCD';
            Put(toprow, leftCol,  attr, '\xC9');
            Put(toprow, rightCol, attr, '\xBB');
            Put(btmrow, leftCol,  attr, '\xC8');
            Put(btmrow, rightCol, attr, '\xBC');
            break;
        case BT_SOLID:
            v = '\xDB';
            h = '\xDB';
            Put(toprow, leftCol,  attr, '\xDB');
            Put(toprow, rightCol, attr, '\xDB');
            Put(btmrow, leftCol,  attr, '\xDB');
            Put(btmrow, rightCol, attr, '\xDB');
        }

    for (short c = leftCol + 1; c < rightCol; ++c)
        {
        Put(toprow, c, attr, h);
        Put(btmrow, c, attr, h);
        }

    for (short r = toprow + 1; r < btmrow; ++r)
        {
        Put(r, leftCol,  attr, v);
        Put(r, rightCol, attr, v);
        }
    }
