//  SCREEN CLASS
//      scrnblbr.cpp    v4.00   02-Aug-1990
//      C++ 2.0
//
//      SetBlink and SetBright methods
//
//      Written by Scott Robert Ladd. Released into the public domain.

#include "screen.h"
#include "conio.h"

// methods which change the purpose of bit 8 in the attribute byte
void Screen::SetBlink()
    {
    char mode_bits;
    unsigned short mode_reg;
    unsigned short far * memptr;

    if (VideoType <= SCR_TYPE_CGA)
        {
        memptr = (unsigned short far *)MK_FP(0x40,0x63);
        mode_reg  = *memptr;

        memptr = (unsigned short far *)MK_FP(0x40,0x65);
        mode_bits = (unsigned char)(0x20 | *memptr);

        outp(mode_reg,mode_bits);

        *memptr = mode_bits;
        }
    else
        {
        _AX = 0x1003;
        _BH = 1;

        geninterrupt(0x10);
        }
    }

void Screen::SetBright()
    {
    char mode_bits;
    unsigned short mode_reg;
    unsigned short far * memptr;

    if ((VideoType == SCR_TYPE_MDA) || (VideoType == SCR_TYPE_HGC))
        return;

    if (VideoType <= SCR_TYPE_CGA)
        {
        memptr = (unsigned short far *)MK_FP(0x40,0x63);
        mode_reg  = *memptr;

        memptr = (unsigned short far *)MK_FP(0x40,0x65);
        mode_bits = (unsigned char)(0xDF & *memptr);

        outp(mode_reg,mode_bits);

        *memptr = mode_bits;
        }
    else
        {
        _AX = 0x1003;
        _BH = 0;

        geninterrupt(0x10);
        }
    }
