//  SHORT BIT SET CLASS
//      sbitset.cpp     3.10    04-Aug-1990
//      Turbo C++ 1.0
//
//      Defines a set of up to 65,536 bits
//
//      Written by Scott Robert Ladd

#include "sbitset.h"

// constructors
ShortBitSet::ShortBitSet(unsigned short size)
    {
    unsigned short alloc;

    Length = size;

    alloc = (size + 7) / 8;

    Data = new unsigned char[(unsigned int)alloc];

    memset(Data,'\x00',(unsigned int)alloc);
    }

ShortBitSet::ShortBitSet(const ShortBitSet & bs)
    {
    unsigned short alloc;

    Length = bs.Length;

    alloc = (bs.Length + 7) / 8;

    Data = new unsigned char[(unsigned int)alloc];

    memcpy(Data,bs.Data,(unsigned int)alloc);
    }

// destructor
ShortBitSet::~ShortBitSet()
    {
    if (Data != NULL)
        delete Data;
    }

// assignment operator
void ShortBitSet::operator = (const ShortBitSet & bs)
    {
    unsigned short alloc;

    if (Length != bs.Length)
        {
        Length = bs.Length;

        alloc = (bs.Length + 7) / 8;

        if (Data != NULL)
            delete Data;

        Data = new unsigned char[(unsigned int)alloc];

        memcpy(Data,bs.Data,(unsigned int)alloc);
        }
    else
        memcpy(Data,bs.Data,(unsigned int)((Length + 7) / 8));
    }

// union operators
ShortBitSet operator & (const ShortBitSet & bs1, const ShortBitSet & bs2)
    {
    ShortBitSet result;

    unsigned short bit;

    if (bs2.Length < bs1.Length)
        {
        result = bs2;

        for (bit = 0; bit < bs1.Length; ++bit)
            if (bs1[bit])
                result.Include(bit);
        }
    else
        {
        result = bs1;

        for (bit = 0; bit < bs2.Length; ++bit)
            if (bs2[bit])
                result.Include(bit);
        }

    return result;
    }

ShortBitSet ShortBitSet::operator +  (const ShortBitSet & bs)
    {
    return (*this & bs);
    }

// intersection operators
ShortBitSet ShortBitSet::operator | (const ShortBitSet & bs)
    {
    ShortBitSet result;

    unsigned short max;

    if (Length > bs.Length)
        {
        result = ShortBitSet(Length);
        max    = bs.Length;
        }
    else
        {
        result = ShortBitSet(bs.Length);
        max    = Length;
        }

    for (unsigned short bit = 0; bit < max; ++bit)
        if ((*this)[bit] & bs[bit])
            result.Include(bit);

    return result;
    }

// difference operators
ShortBitSet ShortBitSet::operator - (const ShortBitSet & bs)
    {
    ShortBitSet result = *this;

    unsigned short stop = (Length < bs.Length) ? Length : bs.Length;

    for (unsigned short bit = 0; bit < stop; ++bit)
        if (bs[bit])
            result.Exclude(bit);

    return result;
    }

// complement operator
ShortBitSet ShortBitSet::operator ~ ()
    {
    ShortBitSet result(Length);

    for (unsigned short bit = 0; bit < Length; ++bit)
        if ((*this)[bit])
            result.Exclude(bit);
        else
            result.Include(bit);

    return result;
    }

// comparison operators
int ShortBitSet::operator == (const ShortBitSet & bs) const
    {
    if (Length != bs.Length)
        return 0;

    for (unsigned short bit = 0; bit < Length; ++bit)
        if ((*this)[bit] != bs[bit])
            return 0;

    return 1;
    }

int ShortBitSet::operator != (const ShortBitSet & bs) const
    {
    if (Length != bs.Length)
        return 1;

    unsigned short bit = 0;

    while (bit < Length)
        if ((*this)[bit] == bs[bit])
            ++bit;
        else
            return 1;

    return 0;
    }
