//  GLOBAL DYNAMIC MEMORY HANDLER TEMPLATE
//      dynamic     1.00    04-Aug-1990
//      Turbo C++ 1.0
//
//      Implements a template for replacing C++'s default memory
//      allocation operators
//
//      Written by Scott Robert Ladd

#include "stddef.h"

#if !defined(DYNAMIC_CPP)
    extern void (* _new_handler)();
#endif

void * operator new (size_t size);

void operator delete (void * ptr);

extern "C"
    {
    void * _vec_new (
        void *       aptr,
        unsigned int num,
        size_t       size,
        void *       (*ctor)(void *));

    void _vec_delete (
        void *       aptr,
        unsigned int num,
        size_t       size,
        int          (*dtor)(int, void *),
        int          freeup);
    }
