//  CHARACTER SET CLASS
//      charset.h   3.10    04-Aug-1990
//      Turbo C++ 1.0
//
//      Provides the equivalent of Pascal's SET OF CHAR.
//
//      Written by Scott Robert Ladd

#if !defined(CHARSET_H)
#define CHARSET_H

#include "sbitset.h"

class CharSet : public ShortBitSet
    {
    public:
        // constructors
        CharSet();
        CharSet(const CharSet & cs);
        CharSet(const char * values);
        CharSet(const ShortBitSet & bs);

        // assignment operator
        void operator = (const CharSet & cs);
        void operator = (const char * values);
    };

// constructors
inline CharSet::CharSet()
    : ShortBitSet(256)
    {
    // empty
    }

inline CharSet::CharSet(const CharSet & cs)
    : ShortBitSet(cs)
    {
    // empty
    }

inline CharSet::CharSet(const ShortBitSet & bs)
    : ShortBitSet(bs)
    {
    // empty
    }

// assignment operator
inline void CharSet::operator = (const CharSet & cs)
    {
    ShortBitSet::operator = (ShortBitSet(cs));
    }

#endif
