echo off

if not exist %1cs.lib goto NOSMALLLIB
echo Patching small library...
call renam s j
tlib %1cs.lib @islib.res
call renam j s
rename istreamf.obj istreamf.obs
rename istreami.obj istreami.obs
rename istreamn.obj istreamn.obs
rename istreamx.obj istreamx.obs
del *.obs
cls
if errorlevel 1 goto ERROR_NOTLIB
goto MEDIUM
:NOSMALLLIB
echo Cannot find CS.LIB to patch small library.

:MEDIUM
if not exist %1cm.lib goto NOMEDLIB
echo Patching medium library...
call renam m j
tlib %1cm.lib @islib.res
call renam j m
rename istreamf.obj istreamf.obm
rename istreami.obj istreami.obm
rename istreamn.obj istreamn.obm
rename istreamx.obj istreamx.obm
del *.obm
cls
goto COMPACT
:NOMEDLIB
echo Cannot find CM.LIB to patch medium library.

:COMPACT
if not exist %1cc.lib goto NOCOMPACTLIB
echo Patching compact library...
call renam c j
tlib %1cc.lib @islib.res
call renam j c
rename istreamf.obj istreamf.obc
rename istreami.obj istreami.obc
rename istreamn.obj istreamn.obc
rename istreamx.obj istreamx.obc
del *.obc
cls
goto LARGE
:NOCOMPACTLIB
echo Cannot find CC.LIB to patch compact library.

:LARGE
if not exist %1cl.lib goto NOLARGELIB
echo Patching large library...
call renam l j
tlib %1cl.lib @islib.res
call renam j l
rename istreamf.obj istreamf.obl
rename istreami.obj istreami.obl
rename istreamn.obj istreamn.obl
rename istreamx.obj istreamx.obl
del *.obl
cls
goto HUGE
:NOLARGELIB
echo Cannot find CL.LIB to patch large library.

:HUGE
if not exist %1ch.lib goto NOHUGELIB
echo Patching huge library...
call renam h j
tlib %1ch.lib @islib.res
call renam j h
rename istreamf.obj istreamf.obh
rename istreami.obj istreami.obh
rename istreamn.obj istreamn.obh
rename istreamx.obj istreamx.obh
del *.obh
cls
goto DONE
:NOHUGELIB
echo Cannot find CH.LIB to patch huge library.
goto DONE

:ERROR_NOOBJ
echo An patch object module is not in the current directory.  Please use
echo unzip on tccpt3.zip and try to patch again.
goto DONE

:ERROR_NOTLIB
echo A problem was encountered executing TLIB.  Either the Turbo Librarian
echo cannot be located along your DOS path, or an error occurred.  Consult
echo your Turbo C++ Users Guide for more information on why TLIB might not
echo be operating correctly.

:DONE
cls
echo Done.
echo Four object modules named ISTREAMF.OBJ, ISTREAMI.OBJ, ISTREAMN.OBJ, and
echo ISTREAMX.OBJ have been removed for each of the libraries for each of the
echo five memory models small, medium, compact, large, and huge.  The last
echo letter of the four file names has been changed to the first letter of
echo the memory model of the library that the module was extracted from.
echo This means that you should have 5 of each of these files differentiated
echo by the last letter of the file name corresponding to the five memory
echo models for each of the file names listed above.  These modules should
echo not be needed again.  Should you decide to use them again however, you
echo must first remove all of the modules from each library listed in the file
echo ISLIB.RES.  You would then need to rename the above four file names to
echo the names as shown above and add them to the appropriate library
echo indicated by the last letter of their current names.

