/* tckey.c
 *
 * Turbo C keyboard interface
 * Taken from 'The compleat keyboard: Retrieving Scan codes and extended
 * keys' by Richard Hale Shaw as published in 'Inside Turbo C', the Cobb Group.
 *
*/
#include     <dos.h>
#include     <conio.h>
#include     "tckey.h"

static int enhanced = FALSE;
#define ENHANCEDKEY 0xE0

/* controls use of Enhanced keyboard calls */
void KbdEnhanced (int is_enhanced)
	{
	enhanced = is_enhanced;
	}

/* retrieves current character from keyboard */
unsigned KbdGetChar(void)
	{
	_AH = (enhanced ? 0x10 : 0);
	geninterrupt(KEYINT);
	if ((_AL == ENHANCEDKEY) && enhanced)
		_AL = 0;
	return _AX;
	}

/* retrieves current keyboard flags */
unsigned KbdFlags(void)
	{
	_AH = (enhanced ? 0x12 : 2);
	geninterrupt(KEYINT);
	return (enhanced ? _AX : _AL);
	}

/* returns character, flags, with wait control */
void KbdCharIn(unsigned *character, unsigned *flags, unsigned wait)
	{
	if (wait)
		while(!KbdHit());
	*character = KbdGetChar();
	*flags = KbdFlags();
	}

int KbdHit(void)
	{
	_AH = (enhanced ? 0x11 : 1);
	geninterrupt(KEYINT);
	asm jnz kbhit
	return FALSE;
kbhit:
	return TRUE;
	}










